/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.jsmaz;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

public final class Smaz {
    private static final int MAX_ASCII = 127;
    private static final int CODE_UTF8_AHEAD = 253;
    private static final int CODE_SINGLE_CHAR_ASCII = 254;
    private static final int CODE_MULTI_CHAR_ASCII = 255;
    private static final int MAXIMAL_VERB_BUFFER_LENGTH = 256;
    private static final String[] CODEBOOK = new String[]{"\u0002s,\u00b6", "\u0003had\u009a\u0002leW", "\u0003on \u008e", "", "\u0001yS", "\u0002ma\u00ad\u0002li\u0097", "\u0003or \u00b0", "", "\u0002ll\u0098\u0003s t\u00bf", "\u0004fromg\u0002mel", "", "\u0003its\u00da", "\u0001z\u00db", "\u0003ingF", "\u0001>\u00de", "\u0001 \u0000\u0003   (\u0002nc\u00e4", "\u0002nd=\u0003 on\u00ca", "\u0002ne\u008b\u0003hat\u00be\u0003re q", "", "\u0002ngT\u0003herz\u0004have\u00c6\u0003s o\u0095", "", "\u0003ionk\u0003s a\u00ac\u0002ly\u00ea", "\u0003hisL\u0003 inN\u0003 be\u00aa", "", "\u0003 fo\u00d5\u0003 of \u0003 ha\u00c9", "", "\u0002of\u0005", "\u0003 co\u00a1\u0002no\u00b7\u0003 ma\u00f8", "", "", "\u0003 cl\u00ee\u0003enta\u0003 an7", "\u0002ns\u00c0\u0001\"e", "\u0003n t\u008f\u0002ntP\u0003s, \u0085", "\u0002pe\u00d0\u0003 we\u00e9\u0002om\u0093", "\u0002on\u001f", "", "\u0002y G", "\u0003 wa\u00b9", "\u0003 re\u00d1\u0002or*", "", "\u0002=\"\u00a9\u0002ot\u00df", "\u0003forD\u0002ou[", "\u0003 toR", "\u0003 th\r", "\u0003 it\u00f6", "\u0003but\u00b1\u0002ra\u0082\u0003 wi\u00f3\u0002</\u00f1", "\u0003 wh\u009f", "\u0002  4", "\u0003nd ?", "\u0002re!", "", "\u0003ng c", "", "\u0003ly \u00c7\u0003ass\u00d3\u0001a\u0004\u0002rir", "", "", "", "\u0002se_", "\u0003of \"", "\u0003div\u00f4\u0002ros\u0003ere\u00a0", "", "\u0002ta\u00c8\u0001bZ\u0002si\u00d4", "", "\u0003and\u0007\u0002rs\u00dd", "\u0002rt\u00f2", "\u0002teE", "\u0003ati\u00ce", "\u0002so\u00b3", "\u0002th\u0011", "\u0002tiJ\u0001c\u001c\u0003allp", "\u0003ate\u00e5", "\u0002ss\u00a6", "\u0002stM", "", "\u0002><\u00e6", "\u0002to\u0014", "\u0003arew", "\u0001d\u0018", "\u0002tr\u00c3", "", "\u0001\n1\u0003 a \u0092", "\u0003f tv\u0002veo", "\u0002un\u00e0", "", "\u0003e o\u00a2", "\u0002a \u00a3\u0002wa\u00d6\u0001e\u0002", "\u0002ur\u0096\u0003e a\u00bc", "\u0002us\u00a4\u0003\n\r\n\u00a7", "\u0002ut\u00c4\u0003e c\u00fb", "\u0002we\u0091", "", "", "\u0002wh\u00c2", "\u0001f,", "", "", "", "\u0003d t\u0086", "", "", "\u0003th \u00e3", "\u0001g;", "", "", "\u0001\r9\u0003e s\u00b5", "\u0003e t\u009c", "", "\u0003to Y", "\u0003e\r\n\u009e", "\u0002d \u001e\u0001h\u0012", "", "\u0001,Q", "\u0002 a\u0019", "\u0002 b^", "\u0002\r\n\u0015\u0002 cI", "\u0002 d\u00a5", "\u0002 e\u00ab", "\u0002 fh\u0001i\b\u0002e \u000b", "", "\u0002 hU\u0001-\u00cc", "\u0002 i8", "", "", "\u0002 l\u00cd", "\u0002 m{", "\u0002f :\u0002 n\u00ec", "\u0002 o\u001d", "\u0002 p}\u0001.n\u0003\r\n\r\u00a8", "", "\u0002 r\u00bd", "\u0002 s>", "\u0002 t\u000e", "", "\u0002g \u009d\u0005which+\u0003whi\u00f7", "\u0002 w5", "\u0001/\u00c5", "\u0003as \u008c", "\u0003at \u0087", "", "\u0003who\u00d9", "", "\u0001l\u0016\u0002h \u008a", "", "\u0002, $", "", "\u0004withV", "", "", "", "\u0001m-", "", "", "\u0002ac\u00ef", "\u0002ad\u00e8", "\u0003TheH", "", "", "\u0004this\u009b\u0001n\t", "", "\u0002. y", "", "\u0002alX\u0003e, \u00f5", "\u0003tio\u008d\u0002be\\", "\u0002an\u001a\u0003ver\u00e7", "", "\u0004that0\u0003tha\u00cb\u0001o\u0006", "\u0003was2", "\u0002arO", "\u0002as.", "\u0002at'\u0003the\u0001\u0004they\u0080\u0005there\u00d2\u0005theird", "\u0002ce\u0088", "\u0004were]", "", "\u0002ch\u0099\u0002l \u00b4\u0001p<", "", "", "\u0003one\u00ae", "", "\u0003he \u0013\u0002dej", "\u0003ter\u00b8", "\u0002cou", "", "\u0002by\u007f\u0002di\u0081\u0002eax", "", "\u0002ec\u00d7", "\u0002edB", "\u0002ee\u00eb", "", "", "\u0001r\f\u0002n )", "", "", "", "\u0002el\u00b2", "", "\u0003in i\u0002en3", "", "\u0002o `\u0001s\n", "", "\u0002er\u001b", "\u0003is t\u0002es6", "", "\u0002ge\u00f9", "", "\u0002fo\u00dc\u0003our\u00d8", "\u0003ch \u00c1\u0001t\u0003", "\u0002hab", "", "\u0003men\u00fc", "", "\u0002he\u0010", "", "", "\u0001u&", "\u0002hif", "", "\u0003not\u0084\u0002ic\u0083", "\u0003ed @\u0002id\u00ed", "", "", "\u0002ho\u00bb", "\u0002r K\u0001vm", "", "", "", "\u0003t t\u00af\u0002il\u00f0", "\u0002im\u00e2", "\u0003en \u00cf\u0002in\u000f", "\u0002io\u0090", "\u0002s \u0017\u0001wA", "", "\u0003er |", "\u0003es ~\u0002is%", "\u0002it/", "", "\u0002iv\u00ba", "", "\u0002t #\u0007http://C\u0001x\u00fa", "\u0002la\u0089", "\u0001<\u00e1", "\u0003, a\u0094"};
    private static final String[] REVERSE_CODEBOOK = new String[]{" ", "the", "e", "t", "a", "of", "o", "and", "i", "n", "s", "e ", "r", " th", " t", "in", "he", "th", "h", "he ", "to", "\r\n", "l", "s ", "d", " a", "an", "er", "c", " o", "d ", "on", " of", "re", "of ", "t ", ", ", "is", "u", "at", "   ", "n ", "or", "which", "f", "m", "as", "it", "that", "\n", "was", "en", "  ", " w", "es", " an", " i", "\r", "f ", "g", "p", "nd", " s", "nd ", "ed ", "w", "ed", "http://", "for", "te", "ing", "y ", "The", " c", "ti", "r ", "his", "st", " in", "ar", "nt", ",", " to", "y", "ng", " h", "with", "le", "al", "to ", "b", "ou", "be", "were", " b", "se", "o ", "ent", "ha", "ng ", "their", "\"", "hi", "from", " f", "in ", "de", "ion", "me", "v", ".", "ve", "all", "re ", "ri", "ro", "is ", "co", "f t", "are", "ea", ". ", "her", " m", "er ", " p", "es ", "by", "they", "di", "ra", "ic", "not", "s, ", "d t", "at ", "ce", "la", "h ", "ne", "as ", "tio", "on ", "n t", "io", "we", " a ", "om", ", a", "s o", "ur", "li", "ll", "ch", "had", "this", "e t", "g ", "e\r\n", " wh", "ere", " co", "e o", "a ", "us", " d", "ss", "\n\r\n", "\r\n\r", "=\"", " be", " e", "s a", "ma", "one", "t t", "or ", "but", "el", "so", "l ", "e s", "s,", "no", "ter", " wa", "iv", "ho", "e a", " r", "hat", "s t", "ns", "ch ", "wh", "tr", "ut", "/", "have", "ly ", "ta", " ha", " on", "tha", "-", " l", "ati", "en ", "pe", " re", "there", "ass", "si", " fo", "wa", "ec", "our", "who", "its", "z", "fo", "rs", ">", "ot", "un", "<", "im", "th ", "nc", "ate", "><", "ver", "ad", " we", "ly", "ee", " n", "id", " cl", "ac", "il", "</", "rt", " wi", "div", "e, ", " it", "whi", " ma", "ge", "x", "e c", "men"};

    private Smaz() {
    }

    public static byte[] compress(String inString) {
        StringBuilder verb = new StringBuilder();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CharBuffer charBuffer = CharBuffer.wrap(inString);
        int remainingCharacters = charBuffer.remaining();
        while (remainingCharacters > 0) {
            int hashForLength1 = 0;
            int hashForLength2 = 0;
            int hashForLength3 = 0;
            charBuffer.mark();
            char current = charBuffer.get();
            if (Smaz.isAscii(current)) {
                int verbLength;
                hashForLength2 = hashForLength1 = current << 3;
                if (remainingCharacters > 1) {
                    hashForLength2 += charBuffer.get();
                }
                hashForLength3 = remainingCharacters > 2 ? hashForLength2 ^ charBuffer.get() : 0;
                charBuffer.reset();
                int j = 7;
                if (j > remainingCharacters) {
                    j = remainingCharacters;
                }
                boolean found = false;
                while (j > 0) {
                    CharBuffer slot = j == 1 ? CharBuffer.wrap(CODEBOOK[hashForLength1 % CODEBOOK.length]) : (j == 2 ? CharBuffer.wrap(CODEBOOK[hashForLength2 % CODEBOOK.length]) : CharBuffer.wrap(CODEBOOK[hashForLength3 % CODEBOOK.length]));
                    int slotLength = slot.length();
                    int slotIndex = 0;
                    int slotEndIndex = slotIndex + j + 1;
                    while (!found && slotLength > 0 && slotEndIndex <= slotLength) {
                        if (slot.get(slotIndex) == j && remainingCharacters >= j && slot.subSequence(slotIndex + 1, slotEndIndex).toString().equals(charBuffer.subSequence(0, j).toString())) {
                            Smaz.flushVerbBuffer(verb, output);
                            output.write(slot.get(slot.get(slotIndex) + '\u0001' + slotIndex));
                            charBuffer.position(charBuffer.position() + j);
                            remainingCharacters -= j;
                            found = true;
                            continue;
                        }
                        slotEndIndex = ++slotIndex + j + 1;
                    }
                    --j;
                }
                if (!found) {
                    if (remainingCharacters > 0) {
                        --remainingCharacters;
                        verb.append(charBuffer.subSequence(0, 1).toString());
                    }
                    charBuffer.position(charBuffer.position() + 1);
                }
                if ((verbLength = verb.length()) == 256 || verbLength > 0 && remainingCharacters == 0) {
                    Smaz.flushVerbBuffer(verb, output);
                }
            } else {
                StringBuilder utf8Str = new StringBuilder();
                char next = current;
                boolean reachedEndOfString = false;
                while (!Smaz.isAscii(next) && !reachedEndOfString) {
                    utf8Str.append(next);
                    if (--remainingCharacters > 0) {
                        next = charBuffer.get();
                        continue;
                    }
                    reachedEndOfString = true;
                }
                Smaz.flushVerbBuffer(verb, output);
                ByteBuffer encoded = StandardCharsets.UTF_8.encode(utf8Str.toString());
                output.write(253);
                output.write(encoded.limit());
                output.write(encoded.array(), 0, encoded.limit());
                if (remainingCharacters > 0) {
                    charBuffer.position(charBuffer.position() - 1);
                }
            }
            remainingCharacters = charBuffer.remaining();
        }
        return output.toByteArray();
    }

    private static boolean isAscii(int c) {
        return c <= 127;
    }

    private static void flushVerbBuffer(StringBuilder verb, ByteArrayOutputStream output) {
        if (verb.length() > 0) {
            Smaz.outputVerb(output, verb.toString());
            verb.setLength(0);
        }
    }

    private static void outputVerb(ByteArrayOutputStream baos, String str) {
        if (str.length() == 1) {
            baos.write(254);
            baos.write(str.toCharArray()[0]);
        } else {
            baos.write(255);
            baos.write(str.length());
            byte[] b = str.getBytes(StandardCharsets.UTF_8);
            baos.write(b, 0, b.length);
        }
    }

    public static String decompress(byte[] strBytes) {
        return Smaz.decompress(strBytes, 0, strBytes.length);
    }

    public static String decompress(byte[] strBytes, int offset, int length) {
        StringBuilder out = new StringBuilder();
        for (int i = offset; i < length + offset; ++i) {
            char b = (char)(0xFF & strBytes[i]);
            if (b == '\u00fd') {
                byte utf8Length = strBytes[++i];
                out.append(new String(strBytes, i + 1, (int)utf8Length, StandardCharsets.UTF_8));
                i += utf8Length;
                continue;
            }
            if (b == '\u00fe') {
                out.append((char)strBytes[++i]);
                continue;
            }
            if (b == '\u00ff') {
                int decodedLength = strBytes[++i];
                for (int j = 1; j <= decodedLength; ++j) {
                    out.append((char)strBytes[i + j]);
                }
                i += decodedLength;
                continue;
            }
            int loc = 0xFF & b;
            out.append(REVERSE_CODEBOOK[loc]);
        }
        return out.toString();
    }
}

