/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal.memory;

import com.github.davidmoten.bplustree.internal.Factory;
import com.github.davidmoten.bplustree.internal.Node;
import com.github.davidmoten.bplustree.internal.NonLeaf;
import com.github.davidmoten.bplustree.internal.Options;

public final class NonLeafMemory<K, V>
implements NonLeaf<K, V> {
    private final Options<K, V> options;
    private final Factory<K, V> factory;
    private final Node<K, V>[] children;
    private final K[] keys;
    private int numKeys;

    NonLeafMemory(Options<K, V> options, Factory<K, V> factory) {
        this.options = options;
        this.factory = factory;
        this.children = new Node[options.maxNonLeafKeys() + 1];
        this.keys = new Object[options.maxLeafKeys()];
    }

    @Override
    public void setNumKeys(int numKeys) {
        this.numKeys = numKeys;
    }

    @Override
    public int numKeys() {
        return this.numKeys;
    }

    @Override
    public void setChild(int index, Node<K, V> node) {
        this.children[index] = node;
    }

    @Override
    public Node<K, V> child(int index) {
        return this.children[index];
    }

    @Override
    public K key(int index) {
        return this.keys[index];
    }

    @Override
    public void setKey(int index, K key) {
        this.keys[index] = key;
    }

    @Override
    public void move(int mid, NonLeaf<K, V> other, int length) {
        other.setNumKeys(length);
        System.arraycopy(this.keys, mid, ((NonLeafMemory)other).keys, 0, length);
        System.arraycopy(this.children, mid, ((NonLeafMemory)other).children, 0, length + 1);
        this.numKeys = mid - 1;
    }

    @Override
    public void insert(int idx, K key, Node<K, V> node) {
        System.arraycopy(this.keys, idx, this.keys, idx + 1, this.numKeys - idx);
        System.arraycopy(this.children, idx, this.children, idx + 1, this.numKeys - idx + 1);
        this.children[idx] = node;
        this.keys[idx] = key;
    }

    @Override
    public Options<K, V> options() {
        return this.options;
    }

    @Override
    public Factory<K, V> factory() {
        return this.factory;
    }
}

