/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal.memory;

import com.github.davidmoten.bplustree.internal.Factory;
import com.github.davidmoten.bplustree.internal.Leaf;
import com.github.davidmoten.bplustree.internal.Options;

public final class LeafMemory<K, V>
implements Leaf<K, V> {
    private final Options<K, V> options;
    private final Factory<K, V> factory;
    private final K[] keys;
    private final V[] values;
    private int numKeys;
    private Leaf<K, V> next;

    public LeafMemory(Options<K, V> options, Factory<K, V> factory) {
        this.options = options;
        this.keys = new Object[options.maxLeafKeys()];
        this.values = new Object[options.maxLeafKeys()];
        this.factory = factory;
    }

    @Override
    public V value(int index) {
        return this.values[index];
    }

    @Override
    public K key(int index) {
        return this.keys[index];
    }

    @Override
    public int numKeys() {
        return this.numKeys;
    }

    @Override
    public void move(int start, int length, Leaf<K, V> other) {
        other.setNumKeys(length);
        System.arraycopy(this.keys, start, ((LeafMemory)other).keys, 0, length);
        System.arraycopy(this.values, start, ((LeafMemory)other).values, 0, length);
        this.numKeys = start;
    }

    @Override
    public void setNumKeys(int numKeys) {
        this.numKeys = numKeys;
    }

    @Override
    public void setValue(int idx, V value) {
        this.values[idx] = value;
    }

    @Override
    public void insert(int idx, K key, V value) {
        System.arraycopy(this.keys, idx, this.keys, idx + 1, this.numKeys - idx);
        System.arraycopy(this.values, idx, this.values, idx + 1, this.numKeys - idx);
        this.keys[idx] = key;
        this.values[idx] = value;
        ++this.numKeys;
    }

    @Override
    public void setNext(Leaf<K, V> next) {
        this.next = next;
    }

    @Override
    public Leaf<K, V> next() {
        return this.next;
    }

    @Override
    public Options<K, V> options() {
        return this.options;
    }

    @Override
    public Factory<K, V> factory() {
        return this.factory;
    }
}

