/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal.file;

import com.github.davidmoten.bplustree.internal.Factory;
import com.github.davidmoten.bplustree.internal.Node;
import com.github.davidmoten.bplustree.internal.NonLeaf;
import com.github.davidmoten.bplustree.internal.Options;
import com.github.davidmoten.bplustree.internal.file.FactoryFile;
import com.github.davidmoten.bplustree.internal.file.NodeFile;

public final class NonLeafFile<K, V>
implements NonLeaf<K, V>,
NodeFile {
    private final Options<K, V> options;
    private final FactoryFile<K, V> factory;
    private final long position;

    public NonLeafFile(Options<K, V> options, FactoryFile<K, V> factory, long position) {
        this.options = options;
        this.factory = factory;
        this.position = position;
    }

    @Override
    public Options<K, V> options() {
        return this.options;
    }

    @Override
    public Factory<K, V> factory() {
        return this.factory;
    }

    @Override
    public void setNumKeys(int numKeys) {
        this.factory.nonLeafSetNumKeys(this.position, numKeys);
    }

    @Override
    public int numKeys() {
        return this.factory.nonLeafNumKeys(this.position);
    }

    @Override
    public void setChild(int index, Node<K, V> node) {
        this.factory.nonLeafSetChild(this.position, index, (NodeFile)((Object)node));
    }

    @Override
    public Node<K, V> child(int index) {
        return this.factory.nonLeafChild(this.position, index);
    }

    @Override
    public K key(int index) {
        return this.factory.nonLeafKey(this.position, index);
    }

    @Override
    public void setKey(int index, K key) {
        this.factory.nonLeafSetKey(this.position, index, key);
    }

    @Override
    public void move(int mid, NonLeaf<K, V> other, int length) {
        this.factory.nonLeafMove(this.position, mid, length, (NonLeafFile)other);
    }

    @Override
    public void insert(int idx, K key, Node<K, V> left) {
        this.factory.nonLeafInsert(this.position, idx, key, (NodeFile)((Object)left));
    }

    @Override
    public long position() {
        return this.position;
    }
}

