/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal.file;

import com.github.davidmoten.bplustree.internal.Leaf;
import com.github.davidmoten.bplustree.internal.Options;
import com.github.davidmoten.bplustree.internal.file.FactoryFile;
import com.github.davidmoten.bplustree.internal.file.NodeFile;

public class LeafFile<K, V>
implements Leaf<K, V>,
NodeFile {
    private final FactoryFile<K, V> factory;
    private long position;
    private final Options<K, V> options;

    public LeafFile(Options<K, V> options, FactoryFile<K, V> factory, long position) {
        this.options = options;
        this.factory = factory;
        this.position = position;
    }

    @Override
    public K key(int i) {
        return this.factory.leafKey(this.position, i);
    }

    @Override
    public int numKeys() {
        return this.factory.leafNumKeys(this.position);
    }

    @Override
    public FactoryFile<K, V> factory() {
        return this.factory;
    }

    @Override
    public Options<K, V> options() {
        return this.options;
    }

    @Override
    public V value(int index) {
        return this.factory.leafValue(this.position, index);
    }

    @Override
    public void setNumKeys(int numKeys) {
        this.factory.leafSetNumKeys(this.position, numKeys);
    }

    @Override
    public void setValue(int idx, V value) {
        this.factory.leafSetValue(this.position, idx, value);
    }

    @Override
    public void insert(int idx, K key, V value) {
        this.factory.leafInsert(this.position, idx, key, value);
    }

    @Override
    public void move(int start, int length, Leaf<K, V> other) {
        this.factory.leafMove(this.position, start, length, (LeafFile)other);
    }

    @Override
    public void setNext(Leaf<K, V> sibling) {
        this.factory.leafSetNext(this.position, (LeafFile)sibling);
    }

    @Override
    public Leaf<K, V> next() {
        return this.factory.leafNext(this.position);
    }

    @Override
    public long position() {
        return this.position;
    }
}

