/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal.file;

import com.github.davidmoten.bplustree.Serializer;
import com.github.davidmoten.bplustree.internal.Factory;
import com.github.davidmoten.bplustree.internal.LargeMappedByteBuffer;
import com.github.davidmoten.bplustree.internal.Leaf;
import com.github.davidmoten.bplustree.internal.Node;
import com.github.davidmoten.bplustree.internal.NonLeaf;
import com.github.davidmoten.bplustree.internal.Options;
import com.github.davidmoten.bplustree.internal.file.LeafFile;
import com.github.davidmoten.bplustree.internal.file.NodeFile;
import com.github.davidmoten.bplustree.internal.file.NonLeafFile;
import java.io.File;

public final class FactoryFile<K, V>
implements Factory<K, V> {
    private static final int NODE_TYPE_BYTES = 1;
    private static final int NUM_KEYS_BYTES = 1;
    private static final int NUM_NODES_BYTES = 4;
    private static final int POSITION_BYTES = 8;
    private static final long NEXT_NOT_PRESENT = -1L;
    private final Options<K, V> options;
    private long index = 8L;
    private long valuesIndex = 0L;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final LargeMappedByteBuffer bb;
    private final LargeMappedByteBuffer values;

    public FactoryFile(Options<K, V> options, File directory, Serializer<K> keySerializer, Serializer<V> valueSerializer, int segmentSizeBytes) {
        this.options = options;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.bb = new LargeMappedByteBuffer(directory, segmentSizeBytes, "index-");
        this.values = new LargeMappedByteBuffer(directory, segmentSizeBytes, "value-");
    }

    @Override
    public Leaf<K, V> createLeaf() {
        return new LeafFile<K, V>(this.options, this, this.leafNextPosition());
    }

    private int leafBytes() {
        return this.relativeLeafKeyPosition(this.options.maxLeafKeys()) + 8;
    }

    private long leafNextPosition() {
        long i = this.index;
        this.bb.position(this.index);
        this.bb.put((byte)0);
        this.bb.position(this.index + (long)this.leafBytes() - 8L);
        this.bb.putLong(-1L);
        this.index += (long)this.leafBytes();
        return i;
    }

    private int relativeLeafKeyPosition(int i) {
        return 2 + i * (this.keySerializer.maxSize() + 8);
    }

    public K leafKey(long position, int i) {
        long p = position + (long)this.relativeLeafKeyPosition(i);
        this.bb.position(p);
        return this.keySerializer.read(this.bb);
    }

    public int leafNumKeys(long position) {
        this.bb.position(position + 1L);
        return this.bb.get() & 0xFF;
    }

    public void leafSetNumKeys(long position, int numKeys) {
        this.bb.position(position + 1L);
        this.bb.put((byte)numKeys);
    }

    public V leafValue(long position, int i) {
        long p = position + (long)this.relativeLeafKeyPosition(i) + (long)this.keySerializer.maxSize();
        this.bb.position(p);
        long valuePos = this.bb.getLong();
        this.values.position(valuePos);
        return this.valueSerializer.read(this.values);
    }

    public void leafSetValue(long position, int i, V value) {
        long p = position + (long)this.relativeLeafKeyPosition(i) + (long)this.keySerializer.maxSize();
        this.bb.position(p);
        this.bb.putLong(this.valuesIndex);
        this.values.position(this.valuesIndex);
        this.valueSerializer.write(this.values, value);
        this.valuesIndex = this.values.position();
    }

    public void leafInsert(long position, int i, K key, V value) {
        int relativeStart = this.relativeLeafKeyPosition(i);
        int relativeFinish = this.relativeLeafKeyPosition(this.leafNumKeys(position));
        this.bb.position(position + (long)relativeStart);
        byte[] bytes = new byte[relativeFinish - relativeStart];
        this.bb.get(bytes);
        this.bb.position(position + (long)this.relativeLeafKeyPosition(i + 1));
        this.bb.put(bytes);
        long p = position + (long)relativeStart;
        this.bb.position(p);
        this.keySerializer.write(this.bb, key);
        this.bb.position(p + (long)this.keySerializer.maxSize());
        this.bb.putLong(this.valuesIndex);
        this.values.position(this.valuesIndex);
        this.valueSerializer.write(this.values, value);
        this.valuesIndex = this.values.position();
        this.leafSetNumKeys(position, this.leafNumKeys(position) + 1);
    }

    public void leafMove(long position, int start, int length, LeafFile<K, V> other) {
        int relativeStart = this.relativeLeafKeyPosition(start);
        int relativeEnd = this.relativeLeafKeyPosition(start + length);
        byte[] bytes = new byte[relativeEnd - relativeStart];
        this.bb.position(position + (long)relativeStart);
        this.bb.get(bytes);
        long p = other.position() + (long)this.relativeLeafKeyPosition(0);
        this.bb.position(p);
        this.bb.put(bytes);
        this.leafSetNumKeys(position, start);
        this.leafSetNumKeys(other.position(), length);
    }

    public void leafSetNext(long position, LeafFile<K, V> sibling) {
        long p = position + (long)this.relativeLeafKeyPosition(this.options.maxLeafKeys());
        long v = sibling == null ? -1L : sibling.position();
        this.bb.position(p);
        this.bb.putLong(v);
    }

    public Leaf<K, V> leafNext(long position) {
        this.bb.position(position + (long)this.relativeLeafKeyPosition(this.options.maxLeafKeys()));
        long p = this.bb.getLong();
        if (p == -1L) {
            return null;
        }
        return new LeafFile<K, V>(this.options, this, p);
    }

    @Override
    public NonLeaf<K, V> createNonLeaf() {
        return new NonLeafFile<K, V>(this.options, this, this.nextNonLeafPosition());
    }

    private int nonLeafBytes() {
        return 5 + this.options.maxNonLeafKeys() * (8 + this.keySerializer.maxSize()) + 8;
    }

    private long nextNonLeafPosition() {
        long i = this.index;
        this.bb.position(this.index);
        this.bb.put((byte)1);
        this.index += (long)this.nonLeafBytes();
        return i;
    }

    public void nonLeafSetNumKeys(long position, int numKeys) {
        this.bb.position(position + 1L);
        this.bb.put((byte)numKeys);
    }

    public int nonLeafNumKeys(long position) {
        this.bb.position(position + 1L);
        return this.bb.get() & 0xFF;
    }

    public void nonLeafSetChild(long position, int i, NodeFile node) {
        long p = position + (long)this.relativePositionNonLeafEntry(i);
        this.bb.position(p);
        this.bb.putLong(node.position());
    }

    private int relativePositionNonLeafEntry(int i) {
        return 2 + i * (8 + this.keySerializer.maxSize());
    }

    public Node<K, V> nonLeafChild(long position, int i) {
        this.bb.position(position + (long)this.relativePositionNonLeafEntry(i));
        long pos = this.bb.getLong();
        return this.readNode(pos);
    }

    private Node<K, V> readNode(long pos) {
        this.bb.position(pos);
        byte type = this.bb.get();
        if (type == 0) {
            return new LeafFile<K, V>(this.options, this, pos);
        }
        return new NonLeafFile<K, V>(this.options, this, pos);
    }

    public K nonLeafKey(long position, int i) {
        this.bb.position(position + (long)this.relativePositionNonLeafEntry(i) + 8L);
        return this.keySerializer.read(this.bb);
    }

    public void nonLeafSetKey(long position, int i, K key) {
        this.bb.position(position + (long)this.relativePositionNonLeafEntry(i) + 8L);
        this.keySerializer.write(this.bb, key);
    }

    public void nonLeafMove(long position, int mid, int length, NonLeafFile<K, V> other) {
        int relativeStart = this.relativePositionNonLeafEntry(mid);
        int size = this.relativePositionNonLeafEntry(mid + length + 1) - relativeStart;
        this.bb.position(position + (long)relativeStart);
        byte[] bytes = new byte[size];
        this.bb.get(bytes);
        long newPosition = other.position() + (long)this.relativePositionNonLeafEntry(0);
        this.bb.position(newPosition);
        this.bb.put(bytes);
        this.nonLeafSetNumKeys(position, mid - 1);
        this.nonLeafSetNumKeys(other.position(), length);
    }

    public void nonLeafInsert(long position, int i, K key, NodeFile left) {
        int numKeys = this.nonLeafNumKeys(position);
        int relativeStart = this.relativePositionNonLeafEntry(i);
        int relativeEnd = this.relativePositionNonLeafEntry(numKeys);
        this.bb.position(position + (long)relativeStart);
        byte[] bytes = new byte[relativeEnd - relativeStart];
        this.bb.get(bytes);
        this.bb.position(position + (long)this.relativePositionNonLeafEntry(i + 1));
        this.bb.put(bytes);
        this.bb.position(relativeStart);
        this.bb.putLong(left.position());
        this.keySerializer.write(this.bb, key);
        this.nonLeafSetNumKeys(position, numKeys + 1);
    }

    @Override
    public void close() throws Exception {
        this.bb.close();
        this.values.close();
    }

    @Override
    public void commit() {
        this.bb.commit();
        this.values.commit();
    }

    @Override
    public void root(Node<K, V> node) {
        this.bb.position(0L);
        this.bb.putLong(((NodeFile)((Object)node)).position());
    }

    @Override
    public Node<K, V> loadOrCreateRoot() {
        this.bb.position(0L);
        long rootPosition = this.bb.getLong();
        if (rootPosition == 0L) {
            this.bb.position(0L);
            this.bb.putLong(8L);
            return this.createLeaf();
        }
        return this.readNode(rootPosition);
    }
}

