/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal;

import com.github.davidmoten.bplustree.internal.Leaf;
import com.github.davidmoten.bplustree.internal.NonLeaf;
import com.github.davidmoten.bplustree.internal.Split;

final class Util {
    Util() {
    }

    static <K, V> void insertNonfull(Leaf<K, V> leaf, K key, V value, int idx) {
        if (idx < leaf.numKeys() && leaf.options().uniqueKeys() && leaf.key(idx).equals(key)) {
            leaf.setValue(idx, value);
        } else {
            leaf.insert(idx, key, value);
        }
    }

    static <K, V> void insertNonfull(NonLeaf<K, V> node, K key, V value) {
        int index = node.getLocation(key);
        Split<K, V> result = node.child(index).insert(key, value);
        if (result != null) {
            if (index == node.numKeys()) {
                node.setKey(index, result.key);
                node.setChild(index, result.left);
                node.setChild(index + 1, result.right);
            } else {
                node.insert(index, result.key, result.left);
                node.setChild(index + 1, result.right);
            }
            node.setNumKeys(node.numKeys() + 1);
        }
    }
}

