/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal;

import com.github.davidmoten.bplustree.internal.FactoryProvider;
import com.github.davidmoten.guavamini.Preconditions;
import java.util.Comparator;

public final class Options<K, V> {
    private final int maxLeafKeys;
    private final int maxNonLeafKeys;
    private final Comparator<? super K> comparator;
    private final boolean uniqueKeys;
    private final FactoryProvider<K, V> factoryProvider;

    public Options(int maxLeafKeys, int maxNonLeafKeys, boolean uniqueKeys, Comparator<? super K> comparator, FactoryProvider<K, V> factoryProvider) {
        Preconditions.checkArgument((0 < maxLeafKeys && maxLeafKeys <= 255 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 < maxNonLeafKeys && maxNonLeafKeys <= 255 ? 1 : 0) != 0);
        this.maxLeafKeys = maxLeafKeys;
        this.maxNonLeafKeys = maxNonLeafKeys;
        this.comparator = comparator;
        this.uniqueKeys = uniqueKeys;
        this.factoryProvider = factoryProvider;
    }

    public int maxLeafKeys() {
        return this.maxLeafKeys;
    }

    public int maxNonLeafKeys() {
        return this.maxNonLeafKeys;
    }

    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    public boolean uniqueKeys() {
        return this.uniqueKeys;
    }

    public FactoryProvider<K, V> factoryProvider() {
        return this.factoryProvider;
    }
}

