/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal;

import com.github.davidmoten.bplustree.internal.Node;
import com.github.davidmoten.bplustree.internal.Split;
import com.github.davidmoten.bplustree.internal.Util;

public interface NonLeaf<K, V>
extends Node<K, V> {
    public static final int TYPE = 1;

    public void setNumKeys(int var1);

    @Override
    public int numKeys();

    public void setChild(int var1, Node<K, V> var2);

    public Node<K, V> child(int var1);

    @Override
    public K key(int var1);

    public void setKey(int var1, K var2);

    public void move(int var1, NonLeaf<K, V> var2, int var3);

    public void insert(int var1, K var2, Node<K, V> var3);

    @Override
    default public Split<K, V> insert(K key, V value) {
        if (this.numKeys() == this.options().maxNonLeafKeys()) {
            int mid = this.options().maxNonLeafKeys() / 2 + 1;
            int len = this.options().maxNonLeafKeys() - mid;
            NonLeaf sibling = this.factory().createNonLeaf();
            this.move(mid, sibling, len);
            Split result = new Split(this.key(mid - 1), this, sibling);
            if (this.options().comparator().compare(key, result.key) < 0) {
                Util.insertNonfull(this, key, value);
            } else {
                Util.insertNonfull(sibling, key, value);
            }
            return result;
        }
        Util.insertNonfull(this, key, value);
        return null;
    }

    @Override
    default public int getLocation(K key) {
        int numKeys = this.numKeys();
        for (int i = 0; i < numKeys; ++i) {
            if (this.options().comparator().compare(this.key(i), key) <= 0) continue;
            return i;
        }
        return numKeys;
    }
}

