/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal;

import com.github.davidmoten.bplustree.internal.Node;
import com.github.davidmoten.bplustree.internal.Options;
import com.github.davidmoten.bplustree.internal.Split;
import com.github.davidmoten.bplustree.internal.Util;

public interface Leaf<K, V>
extends Node<K, V> {
    public static final int TYPE = 0;

    @Override
    public Options<K, V> options();

    public V value(int var1);

    public void setNumKeys(int var1);

    public void setValue(int var1, V var2);

    public void insert(int var1, K var2, V var3);

    public void move(int var1, int var2, Leaf<K, V> var3);

    public void setNext(Leaf<K, V> var1);

    public Leaf<K, V> next();

    @Override
    default public Split<K, V> insert(K key, V value) {
        int i = this.getLocation(key);
        if (this.numKeys() == this.options().maxLeafKeys()) {
            int mid = (this.options().maxLeafKeys() + 1) / 2;
            int len = this.numKeys() - mid;
            Leaf sibling = this.factory().createLeaf();
            this.move(mid, len, sibling);
            if (i < mid) {
                Util.insertNonfull(this, key, value, i);
            } else {
                Util.insertNonfull(sibling, key, value, i - mid);
            }
            this.setNext(sibling);
            return new Split(sibling.key(0), this, sibling);
        }
        Util.insertNonfull(this, key, value, i);
        return null;
    }

    @Override
    default public int getLocation(K key) {
        int numKeys = this.numKeys();
        for (int i = 0; i < numKeys; ++i) {
            if (this.options().comparator().compare(this.key(i), key) < 0) continue;
            return i;
        }
        return numKeys;
    }
}

