/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree.internal;

import com.github.davidmoten.bplustree.LargeByteBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.TreeMap;

public final class LargeMappedByteBuffer
implements AutoCloseable,
LargeByteBuffer {
    private final int segmentSizeBytes;
    private final TreeMap<Long, Segment> map = new TreeMap();
    private final File directory;
    private final String segmentNamePrefix;
    private byte[] temp2Bytes = new byte[2];
    private byte[] temp4Bytes = new byte[4];
    private byte[] temp8Bytes = new byte[8];
    private long position;

    public LargeMappedByteBuffer(File directory, int segmentSizeBytes, String segmentNamePrefix) {
        this.directory = directory;
        this.segmentSizeBytes = segmentSizeBytes;
        this.segmentNamePrefix = segmentNamePrefix;
    }

    private MappedByteBuffer bb(long position) {
        long num = this.segmentNumber(position);
        Segment segment = this.map.get(num);
        if (segment == null) {
            segment = this.createSegment(num);
        }
        segment.bb.position((int)(position % (long)this.segmentSizeBytes));
        return segment.bb;
    }

    private Segment createSegment(long num) {
        File file = new File(this.directory, this.segmentNamePrefix + num);
        Segment segment = LargeMappedByteBuffer.map(file, this.segmentSizeBytes);
        this.map.put(num, segment);
        return segment;
    }

    private static Segment map(File file, int segmentSizeBytes) {
        try {
            if (file.exists() && file.length() != (long)segmentSizeBytes) {
                throw new IllegalStateException("segment file " + file + " should be of size " + segmentSizeBytes + " but was of size " + file.length());
            }
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.setLength(segmentSizeBytes);
            }
            FileChannel channel = (FileChannel)Files.newByteChannel(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            MappedByteBuffer bb = channel.map(FileChannel.MapMode.READ_WRITE, 0L, segmentSizeBytes);
            return new Segment(channel, bb);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void position(long newPosition) {
        this.position = newPosition;
    }

    @Override
    public byte get() {
        return this.bb(this.position++).get();
    }

    @Override
    public void put(byte b) {
        this.bb(this.position++).put(b);
    }

    @Override
    public void get(byte[] dst) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + (long)dst.length)) {
            this.bb(p).get(dst);
        } else {
            long p2;
            int length;
            int i = 0;
            while ((length = (int)((p2 = Math.min(this.segmentPosition(this.segmentNumber(p) + 1L), this.position + (long)dst.length)) - p)) != 0) {
                this.bb(p).get(dst, i, length);
                i += length;
                p = p2;
            }
        }
        this.position += (long)dst.length;
    }

    @Override
    public void put(byte[] src) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + (long)src.length)) {
            this.bb(p).put(src);
        } else {
            long p2;
            int length;
            int i = 0;
            while ((length = (int)((p2 = Math.min(this.segmentPosition(this.segmentNumber(p) + 1L), this.position + (long)src.length)) - p)) != 0) {
                this.bb(p).put(src, i, length);
                i += length;
                p = p2;
            }
        }
        this.position += (long)src.length;
    }

    @Override
    public int getInt() {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 4L)) {
            this.position += 4L;
            return this.bb(p).getInt();
        }
        this.get(this.temp4Bytes);
        return LargeMappedByteBuffer.toInt(this.temp4Bytes);
    }

    @Override
    public void putInt(int value) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 4L)) {
            this.bb(p).putInt(value);
            this.position += 4L;
        } else {
            this.put(LargeMappedByteBuffer.toBytes(value));
        }
    }

    @Override
    public long getLong() {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 8L)) {
            this.position += 8L;
            return this.bb(p).getLong();
        }
        this.get(this.temp8Bytes);
        return LargeMappedByteBuffer.toLong(this.temp8Bytes);
    }

    @Override
    public void putLong(long value) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 8L)) {
            this.position += 8L;
            this.bb(p).putLong(value);
        } else {
            this.put(LargeMappedByteBuffer.toBytes(value));
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public short getShort() {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 2L)) {
            this.position += 2L;
            return this.bb(p).getShort();
        }
        this.get(this.temp2Bytes);
        return this.toShort(this.temp2Bytes);
    }

    @Override
    public void putShort(short value) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 2L)) {
            this.bb(p).putShort(value);
            this.position += 2L;
        } else {
            this.put(LargeMappedByteBuffer.toBytes(value));
        }
    }

    private long segmentNumber(long position) {
        return position / (long)this.segmentSizeBytes;
    }

    private long segmentPosition(long segmentNumber) {
        return (long)this.segmentSizeBytes * segmentNumber;
    }

    private static byte[] toBytes(short n) {
        return ByteBuffer.allocate(2).putShort(n).array();
    }

    private static byte[] toBytes(int n) {
        return ByteBuffer.allocate(4).putInt(n).array();
    }

    private static byte[] toBytes(long n) {
        return ByteBuffer.allocate(8).putLong(n).array();
    }

    private static byte[] toBytes(double n) {
        return ByteBuffer.allocate(8).putDouble(n).array();
    }

    private static byte[] toBytes(float n) {
        return ByteBuffer.allocate(4).putFloat(n).array();
    }

    private short toShort(byte[] bytes) {
        short ret = 0;
        for (int i = 0; i < 2; ++i) {
            ret = (short)(ret << 8);
            ret = (short)(ret | bytes[i] & 0xFF);
        }
        return ret;
    }

    private static int toInt(byte[] bytes) {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            ret <<= 8;
            ret |= bytes[i] & 0xFF;
        }
        return ret;
    }

    private static long toLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    private static double toDouble(byte[] b) {
        return ByteBuffer.wrap(b).getDouble();
    }

    private static double toFloat(byte[] b) {
        return ByteBuffer.wrap(b).getFloat();
    }

    @Override
    public void commit() {
        for (Segment segment : this.map.values()) {
            segment.bb.force();
        }
    }

    @Override
    public void close() throws IOException {
        for (Segment segment : this.map.values()) {
            segment.close();
        }
        this.map.clear();
    }

    @Override
    public double getDouble() {
        this.get(this.temp8Bytes);
        return LargeMappedByteBuffer.toDouble(this.temp8Bytes);
    }

    @Override
    public void putDouble(double value) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 8L)) {
            this.bb(p).putDouble(value);
            this.position += 8L;
        } else {
            this.put(LargeMappedByteBuffer.toBytes(value));
        }
    }

    @Override
    public double getFloat() {
        this.get(this.temp4Bytes);
        return LargeMappedByteBuffer.toFloat(this.temp4Bytes);
    }

    @Override
    public void putFloat(float value) {
        long p = this.position;
        if (this.segmentNumber(p) == this.segmentNumber(p + 4L)) {
            this.bb(p).putFloat(value);
            this.position += 4L;
        } else {
            this.put(LargeMappedByteBuffer.toBytes(value));
        }
    }

    @Override
    public String getString() {
        int length = this.getInt();
        byte[] bytes = new byte[length];
        this.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public void putString(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.putInt(bytes.length);
        this.put(bytes);
    }

    private static final class Segment {
        private final FileChannel channel;
        final MappedByteBuffer bb;

        Segment(FileChannel channel, MappedByteBuffer bb) {
            this.channel = channel;
            this.bb = bb;
        }

        public void close() throws IOException {
            this.channel.close();
        }
    }
}

