/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree;

import com.github.davidmoten.bplustree.LargeByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface Serializer<T> {
    public static final Serializer<Short> SHORT = new Serializer<Short>(){

        @Override
        public Short read(LargeByteBuffer bb) {
            return bb.getShort();
        }

        @Override
        public void write(LargeByteBuffer bb, Short t) {
            bb.putShort(t);
        }

        @Override
        public int maxSize() {
            return 2;
        }
    };
    public static final Serializer<Integer> INTEGER = new Serializer<Integer>(){

        @Override
        public Integer read(LargeByteBuffer bb) {
            return bb.getInt();
        }

        @Override
        public void write(LargeByteBuffer bb, Integer t) {
            bb.putInt(t);
        }

        @Override
        public int maxSize() {
            return 4;
        }
    };
    public static final Serializer<Long> LONG = new Serializer<Long>(){

        @Override
        public Long read(LargeByteBuffer bb) {
            return bb.getLong();
        }

        @Override
        public void write(LargeByteBuffer bb, Long t) {
            bb.putLong(t);
        }

        @Override
        public int maxSize() {
            return 8;
        }
    };
    public static final Serializer<Float> FLOAT = new Serializer<Float>(){

        @Override
        public Float read(LargeByteBuffer bb) {
            return Float.valueOf(Double.valueOf(bb.getFloat()).floatValue());
        }

        @Override
        public void write(LargeByteBuffer bb, Float t) {
            bb.putFloat(t.floatValue());
        }

        @Override
        public int maxSize() {
            return 4;
        }
    };
    public static final Serializer<Double> DOUBLE = new Serializer<Double>(){

        @Override
        public Double read(LargeByteBuffer bb) {
            return bb.getDouble();
        }

        @Override
        public void write(LargeByteBuffer bb, Double t) {
            bb.putDouble(t);
        }

        @Override
        public int maxSize() {
            return 8;
        }
    };

    public T read(LargeByteBuffer var1);

    public void write(LargeByteBuffer var1, T var2);

    public int maxSize();

    public static Serializer<String> utf8(int maxSize) {
        return Serializer.string(StandardCharsets.UTF_8, maxSize);
    }

    public static Serializer<String> string(Charset charset, final int maxSize) {
        return new Serializer<String>(){

            @Override
            public String read(LargeByteBuffer bb) {
                return bb.getString();
            }

            @Override
            public void write(LargeByteBuffer bb, String s) {
                bb.putString(s);
            }

            @Override
            public int maxSize() {
                return maxSize;
            }
        };
    }

    public static Serializer<byte[]> bytes(final int maxSize) {
        return new Serializer<byte[]>(){

            @Override
            public byte[] read(LargeByteBuffer bb) {
                int size = bb.getInt();
                byte[] bytes = new byte[size];
                bb.get(bytes);
                return bytes;
            }

            @Override
            public void write(LargeByteBuffer bb, byte[] bytes) {
                bb.putInt(bytes.length);
                bb.put(bytes);
            }

            @Override
            public int maxSize() {
                return maxSize;
            }
        };
    }
}

