/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bplustree;

import com.github.davidmoten.bplustree.Entry;
import com.github.davidmoten.bplustree.Serializer;
import com.github.davidmoten.bplustree.internal.Factory;
import com.github.davidmoten.bplustree.internal.FactoryProvider;
import com.github.davidmoten.bplustree.internal.Leaf;
import com.github.davidmoten.bplustree.internal.Node;
import com.github.davidmoten.bplustree.internal.NonLeaf;
import com.github.davidmoten.bplustree.internal.Options;
import com.github.davidmoten.bplustree.internal.Split;
import com.github.davidmoten.bplustree.internal.file.FactoryFile;
import com.github.davidmoten.bplustree.internal.memory.FactoryMemory;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

public final class BPlusTree<K, V>
implements AutoCloseable {
    private static final int MAX_KEYS_NOT_SPECIFIED = -1;
    private static final int DEFAULT_NUM_KEYS = 4;
    private final Options<K, V> options;
    private final Factory<K, V> factory;
    private Node<K, V> root;
    private static final int VALUES_MAX_SIZE = 256;

    private BPlusTree(int maxLeafKeys, int maxInnerKeys, boolean uniqueKeys, Comparator<? super K> comparator, FactoryProvider<K, V> factoryProvider) {
        this.options = new Options<K, V>(maxLeafKeys, maxInnerKeys, uniqueKeys, comparator, factoryProvider);
        this.factory = this.options.factoryProvider().createFactory(this.options);
        this.root = this.factory.loadOrCreateRoot();
        this.factory.root(this.root);
    }

    public static Builder memory() {
        return new Builder();
    }

    public static BuilderFile file() {
        return new BuilderFile();
    }

    public void insert(K key, V value) {
        Split<K, V> result = this.root.insert(key, value);
        if (result != null) {
            NonLeaf node = this.factory.createNonLeaf();
            node.setNumKeys(1);
            node.setKey(0, result.key);
            node.setChild(0, result.left);
            node.setChild(1, result.right);
            this.root = node;
            this.factory.root(this.root);
            this.factory.commit();
        }
    }

    public V findFirst(K key) {
        Leaf<K, V> leaf = this.findFirstLeaf(key);
        int idx = leaf.getLocation(key);
        if (idx < leaf.numKeys() && leaf.key(idx).equals(key)) {
            return leaf.value(idx);
        }
        return null;
    }

    public Iterable<V> find(K key) {
        return this.find(key, key, true);
    }

    private Leaf<K, V> findFirstLeaf(K key) {
        Node<K, V> node = this.root;
        while (node instanceof NonLeaf) {
            NonLeaf inner = (NonLeaf)node;
            int idx = inner.getLocation(key);
            node = inner.child(idx);
        }
        return (Leaf)node;
    }

    public Iterable<V> find(K startInclusive, K finishExclusive) {
        return this.find(startInclusive, finishExclusive, false);
    }

    public Iterable<V> find(K startInclusive, K finish, boolean isFinishInclusive) {
        return this.find(startInclusive, finish, isFinishInclusive, (k, v) -> v);
    }

    public Iterable<Entry<K, V>> findEntries(K startInclusive, K finishExclusive) {
        return this.findEntries(startInclusive, finishExclusive, false);
    }

    public Iterable<Entry<K, V>> findEntries(K startInclusive, K finish, boolean isFinishInclusive) {
        return this.find(startInclusive, finish, isFinishInclusive, (k, v) -> Entry.create(k, v));
    }

    public <R> Iterable<R> find(final K startInclusive, final K finish, final boolean isFinishInclusive, final BiFunction<K, V, R> mapper) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    Leaf<K, V> leaf;
                    int idx;
                    R value;
                    {
                        this.leaf = BPlusTree.this.findFirstLeaf(startInclusive);
                        this.idx = this.leaf.getLocation(startInclusive);
                    }

                    @Override
                    public boolean hasNext() {
                        this.load();
                        return this.value != null;
                    }

                    @Override
                    public R next() {
                        this.load();
                        Object v = this.value;
                        this.value = null;
                        if (v == null) {
                            throw new NoSuchElementException();
                        }
                        return v;
                    }

                    private void load() {
                        if (this.value != null) {
                            return;
                        }
                        while (this.leaf != null) {
                            if (this.idx < this.leaf.numKeys()) {
                                Object key = this.leaf.key(this.idx);
                                int c = BPlusTree.this.options.comparator().compare(key, finish);
                                if (c < 0 || c == 0 && isFinishInclusive) {
                                    this.value = mapper.apply(key, this.leaf.value(this.idx));
                                    ++this.idx;
                                } else {
                                    this.leaf = null;
                                }
                                return;
                            }
                            this.leaf = this.leaf.next();
                            this.idx = 0;
                        }
                        return;
                    }
                };
            }
        };
    }

    public Iterable<V> findOrderPreserving(K startInclusive, K finishExclusive) {
        return this.findOrderPreserving(startInclusive, finishExclusive, false);
    }

    public Iterable<V> findOrderPreserving(K startInclusive, K finish, boolean isFinishInclusive) {
        return this.findEntriesOrderPreserving(startInclusive, finish, isFinishInclusive, (k, v) -> v);
    }

    public Iterable<Entry<K, V>> findEntriesOrderPreserving(K startInclusive, K finish, boolean isFinishInclusive) {
        return this.findEntriesOrderPreserving(startInclusive, finish, isFinishInclusive, (k, v) -> Entry.create(k, v));
    }

    public <R> Iterable<R> findEntriesOrderPreserving(final K startInclusive, final K finish, final boolean isFinishInclusive, final BiFunction<K, V, R> mapper) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){
                    Leaf<K, V> leaf;
                    int idx;
                    K currentKey;
                    List<R> values;
                    int valuesIdx;
                    List<R> nextValues;
                    {
                        this.leaf = BPlusTree.this.findFirstLeaf(startInclusive);
                        this.idx = this.leaf.getLocation(startInclusive);
                        this.values = new ArrayList();
                        this.valuesIdx = 0;
                        this.nextValues = new ArrayList();
                    }

                    @Override
                    public boolean hasNext() {
                        this.load();
                        return this.valuesIdx < this.values.size();
                    }

                    @Override
                    public R next() {
                        this.load();
                        int size = this.values.size();
                        if (this.valuesIdx >= size) {
                            throw new NoSuchElementException();
                        }
                        Object v = this.values.set(size - this.valuesIdx - 1, null);
                        ++this.valuesIdx;
                        return v;
                    }

                    private void load() {
                        if (this.valuesIdx < this.values.size()) {
                            return;
                        }
                        this.valuesIdx = 0;
                        List temp = this.values = BPlusTree.clear(this.values, 256);
                        this.values = this.nextValues;
                        this.nextValues = temp;
                        while (this.leaf != null) {
                            if (this.idx < this.leaf.numKeys()) {
                                Object key = this.leaf.key(this.idx);
                                int c = BPlusTree.this.options.comparator().compare(key, finish);
                                if (c < 0 || c == 0 && isFinishInclusive) {
                                    if (this.currentKey == null) {
                                        this.currentKey = key;
                                    }
                                    Object r = mapper.apply(key, this.leaf.value(this.idx));
                                    if (BPlusTree.this.options.comparator().compare(this.currentKey, key) == 0) {
                                        this.values.add(r);
                                        ++this.idx;
                                        continue;
                                    }
                                    this.currentKey = key;
                                    this.nextValues.add(r);
                                    ++this.idx;
                                    return;
                                }
                                this.leaf = null;
                                return;
                            }
                            this.leaf = this.leaf.next();
                            this.idx = 0;
                        }
                        return;
                    }
                };
            }
        };
    }

    @VisibleForTesting
    static <T> List<T> clear(List<T> values, int maxSize) {
        if (values.size() > maxSize) {
            return new ArrayList();
        }
        values.clear();
        return values;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        BPlusTree.print(this.root, 0, out);
    }

    private static <K, V> void print(Node<K, V> node, int level, PrintStream out) {
        if (node instanceof Leaf) {
            BPlusTree.print((Leaf)node, level, out);
        } else {
            BPlusTree.print((NonLeaf)node, level, out);
        }
    }

    private static <K, V> void print(Leaf<K, V> node, int level, PrintStream out) {
        out.print(BPlusTree.indent(level));
        out.print("Leaf: ");
        int n = node.numKeys();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(node.key(i));
            out.print("->");
            out.print(node.value(i));
        }
        if (node.next() != null) {
            out.print("| -> " + node.next().keys());
        }
        out.println();
    }

    private static <K, V> void print(NonLeaf<K, V> node, int level, PrintStream out) {
        out.print(BPlusTree.indent(level));
        out.println("NonLeaf");
        int n = node.numKeys();
        for (int i = 0; i < n; ++i) {
            Node<K, V> nd = node.child(i);
            BPlusTree.print(nd, level + 1, out);
            out.print(BPlusTree.indent(level) + node.key(i));
            out.println();
        }
        if (node.child(n) != null) {
            BPlusTree.print(node.child(n), level + 1, out);
        }
        out.println();
    }

    private static String indent(int level) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            b.append("  ");
        }
        return b.toString();
    }

    Node<K, V> root() {
        return this.root;
    }

    @Override
    public void close() throws Exception {
        this.factory.close();
    }

    public void commit() {
        this.factory.commit();
    }

    public static final class Builder {
        private int maxLeafKeys = -1;
        private int maxInnerKeys = -1;
        private boolean uniqueKeys = false;

        Builder() {
        }

        public Builder maxLeafKeys(int maxLeafKeys) {
            this.maxLeafKeys = maxLeafKeys;
            return this;
        }

        public Builder maxNonLeafKeys(int maxInnerKeys) {
            this.maxInnerKeys = maxInnerKeys;
            return this;
        }

        public Builder maxKeys(int maxKeys) {
            this.maxLeafKeys(maxKeys);
            return this.maxNonLeafKeys(maxKeys);
        }

        public Builder uniqueKeys(boolean uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            return this;
        }

        public <K, V> BPlusTree<K, V> naturalOrder() {
            return this.comparator(Comparator.naturalOrder());
        }

        public Builder uniqueKeys() {
            return this.uniqueKeys(true);
        }

        public <K, V> BPlusTree<K, V> comparator(Comparator<? super K> comparator) {
            FactoryProvider factoryProvider = options -> new FactoryMemory(options);
            if (this.maxLeafKeys == -1) {
                if (this.maxInnerKeys == -1) {
                    this.maxLeafKeys = 4;
                    this.maxInnerKeys = 4;
                } else {
                    this.maxLeafKeys = this.maxInnerKeys;
                }
            } else if (this.maxInnerKeys == -1) {
                this.maxInnerKeys = this.maxLeafKeys;
            }
            return new BPlusTree(this.maxLeafKeys, this.maxInnerKeys, this.uniqueKeys, comparator, factoryProvider);
        }
    }

    public static final class BuilderFile4<K, V> {
        private final BuilderFile2 b;
        private final Serializer<K> keySerializer;
        private final Serializer<V> valueSerializer;

        BuilderFile4(BuilderFile2 b, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            this.b = b;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        public BPlusTree<K, V> naturalOrder() {
            return this.comparator(Comparator.naturalOrder());
        }

        public BPlusTree<K, V> comparator(Comparator<? super K> comparator) {
            FactoryProvider factoryProvider = options -> new FactoryFile<K, V>(options, this.b.directory, this.keySerializer, this.valueSerializer, this.b.segmentSizeBytes);
            if (this.b.maxLeafKeys == -1) {
                if (this.b.maxNonLeafKeys == -1) {
                    this.b.maxLeafKeys = 4;
                    this.b.maxNonLeafKeys = 4;
                } else {
                    this.b.maxLeafKeys = this.b.maxNonLeafKeys;
                }
            } else if (this.b.maxNonLeafKeys == -1) {
                this.b.maxNonLeafKeys = this.b.maxLeafKeys;
            }
            return new BPlusTree(this.b.maxLeafKeys, this.b.maxNonLeafKeys, this.b.uniqueKeys, comparator, factoryProvider);
        }
    }

    public static final class BuilderFile3<K> {
        private BuilderFile2 b;
        private final Serializer<K> keySerializer;

        BuilderFile3(BuilderFile2 b, Serializer<K> serializer) {
            this.b = b;
            this.keySerializer = serializer;
        }

        public <V> BuilderFile4<K, V> valueSerializer(Serializer<V> valueSerializer) {
            return new BuilderFile4<K, V>(this.b, this.keySerializer, valueSerializer);
        }
    }

    public static final class BuilderFile2 {
        File directory;
        int segmentSizeBytes = 0x3200000;
        int maxLeafKeys = -1;
        int maxNonLeafKeys = -1;
        boolean uniqueKeys = false;

        BuilderFile2(File directory) {
            this.directory = directory;
        }

        public BuilderFile2 segmentSizeBytes(int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
            this.segmentSizeBytes = size;
            return this;
        }

        public BuilderFile2 segmentSizeMB(int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
            return this.segmentSizeBytes(size * 1024 * 1024);
        }

        public BuilderFile2 maxLeafKeys(int maxLeafKeys) {
            this.maxLeafKeys = maxLeafKeys;
            return this;
        }

        public BuilderFile2 maxNonLeafKeys(int maxNonLeafKeys) {
            this.maxNonLeafKeys = maxNonLeafKeys;
            return this;
        }

        public BuilderFile2 maxKeys(int maxKeys) {
            this.maxLeafKeys(maxKeys);
            return this.maxNonLeafKeys(maxKeys);
        }

        public <K> BuilderFile3<K> keySerializer(Serializer<K> serializer) {
            Preconditions.checkArgument((serializer.maxSize() > 0 ? 1 : 0) != 0, (String)"key serializer must have non-zero maxSize");
            return new BuilderFile3<K>(this, serializer);
        }
    }

    public static final class BuilderFile {
        BuilderFile() {
        }

        public BuilderFile2 directory(String directory) {
            Preconditions.checkNotNull((Object)directory);
            return this.directory(new File(directory));
        }

        public BuilderFile2 directory(File directory) {
            Preconditions.checkNotNull((Object)directory);
            return new BuilderFile2(directory);
        }
    }
}

