/*
 * Decompiled with CFR 0.152.
 */
package com.github.datatables4j.plugins.compression;

import com.github.datatables4j.core.api.compressor.WebResourceCompressor;
import com.github.datatables4j.core.api.exception.CompressionException;
import com.github.datatables4j.core.api.model.HtmlTable;
import com.github.datatables4j.core.api.model.TableProperties;
import com.github.datatables4j.plugins.compression.YuiCompressorErrorReporter;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuiResourceCompressor
implements WebResourceCompressor {
    private static Logger logger = LoggerFactory.getLogger(YuiResourceCompressor.class);

    public String getCompressedJavascript(HtmlTable table, String input) throws CompressionException {
        StringWriter output = new StringWriter();
        JavaScriptCompressor compressor = null;
        TableProperties props = table.getTableProperties();
        try {
            compressor = new JavaScriptCompressor((Reader)new StringReader(input), (ErrorReporter)new YuiCompressorErrorReporter());
            compressor.compress((Writer)output, -1, props.getCompressorMunge().booleanValue(), false, props.getCompressorPreserveSemi().booleanValue(), props.getCompressorDisableOpti().booleanValue());
        }
        catch (EvaluatorException e) {
            logger.error("Unable to compress Javascript resource");
            throw new CompressionException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to compress Javascript resource");
            throw new CompressionException((Throwable)e);
        }
        return ((Object)output).toString();
    }

    public String getCompressedCss(String input) throws CompressionException {
        StringWriter output = new StringWriter();
        try {
            CssCompressor compressor = new CssCompressor((Reader)new StringReader(input));
            compressor.compress((Writer)output, -1);
        }
        catch (IOException e) {
            logger.error("Unable to compress Css resource");
            throw new CompressionException((Throwable)e);
        }
        return ((Object)output).toString();
    }
}

