/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.datatables;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.datatables.DataTablesInput;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class DataTablesCriteria {
    private final Query query = new Query();

    DataTablesCriteria(DataTablesInput input, Criteria additionalCriteria, Criteria preFilteringCriteria) {
        this.addGlobalCriteria(input);
        input.getColumns().forEach(this::addColumnCriteria);
        this.addSort(input);
        if (additionalCriteria != null) {
            this.query.addCriteria((CriteriaDefinition)additionalCriteria);
        }
        if (preFilteringCriteria != null) {
            this.query.addCriteria((CriteriaDefinition)preFilteringCriteria);
        }
    }

    Query toQuery() {
        return this.query;
    }

    private void addGlobalCriteria(DataTablesInput input) {
        if (!StringUtils.hasText((String)input.getSearch().getValue())) {
            return;
        }
        Criteria[] criteriaArray = (Criteria[])input.getColumns().stream().filter(DataTablesInput.Column::isSearchable).map(column -> this.createCriteria((DataTablesInput.Column)column, input.getSearch())).toArray(Criteria[]::new);
        if (criteriaArray.length == 1) {
            this.query.addCriteria((CriteriaDefinition)criteriaArray[0]);
        } else if (criteriaArray.length >= 2) {
            this.query.addCriteria((CriteriaDefinition)new Criteria().orOperator(criteriaArray));
        }
    }

    private void addColumnCriteria(DataTablesInput.Column column) {
        if (column.isSearchable() && StringUtils.hasText((String)column.getSearch().getValue())) {
            this.query.addCriteria((CriteriaDefinition)this.createColumnCriteria(column));
        }
    }

    private Criteria createColumnCriteria(DataTablesInput.Column column) {
        String searchValue = column.getSearch().getValue();
        if ("true".equalsIgnoreCase(searchValue) || "false".equalsIgnoreCase(searchValue)) {
            return Criteria.where((String)column.getData()).is((Object)Boolean.valueOf(searchValue));
        }
        return this.createCriteria(column, column.getSearch());
    }

    private Criteria createCriteria(DataTablesInput.Column column, DataTablesInput.Search search) {
        String searchValue = search.getValue();
        if (search.isRegex()) {
            return Criteria.where((String)column.getData()).regex(searchValue);
        }
        return Criteria.where((String)column.getData()).regex(searchValue.trim(), "i");
    }

    private void addSort(DataTablesInput input) {
        this.query.skip((long)input.getStart());
        this.query.limit(input.getLength());
        if (ObjectUtils.isEmpty(input.getOrder())) {
            return;
        }
        List orders = input.getOrder().stream().filter(order -> this.isOrderable(input, (DataTablesInput.Order)order)).map(order -> this.toOrder(input, (DataTablesInput.Order)order)).collect(Collectors.toList());
        this.query.with(Sort.by(orders));
    }

    private boolean isOrderable(DataTablesInput input, DataTablesInput.Order order) {
        boolean isWithinBounds = order.getColumn() < input.getColumns().size();
        return isWithinBounds && input.getColumns().get(order.getColumn()).isOrderable();
    }

    private Sort.Order toOrder(DataTablesInput input, DataTablesInput.Order order) {
        return new Sort.Order(order.getDir() == DataTablesInput.Order.Direction.asc ? Sort.Direction.ASC : Sort.Direction.DESC, input.getColumns().get(order.getColumn()).getData());
    }
}

