/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.datatables;

import java.io.Serializable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.datatables.DataTablesRepository;
import org.springframework.data.mongodb.datatables.DataTablesRepositoryImpl;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public final class DataTablesRepositoryFactoryBean<R extends MongoRepository<T, ID>, T, ID extends Serializable>
extends MongoRepositoryFactoryBean<R, T, ID> {
    public DataTablesRepositoryFactoryBean(Class<? extends R> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport getFactoryInstance(MongoOperations operations) {
        return new DataTablesRepositoryFactory(operations);
    }

    private static class DataTablesRepositoryFactory
    extends MongoRepositoryFactory {
        DataTablesRepositoryFactory(MongoOperations mongoOperations) {
            super(mongoOperations);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            if (DataTablesRepository.class.isAssignableFrom(repositoryInterface)) {
                return DataTablesRepositoryImpl.class;
            }
            return super.getRepositoryBaseClass(metadata);
        }
    }
}

