/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.datatables;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class DataTablesInput {
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) int draw = 1;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) int start = 0;
    @NotNull
    @Min(value=-1L)
    private @NotNull @Min(value=-1L) int length = 10;
    @NotNull
    private Search search;
    @NotEmpty
    private List<Order> order;
    @NotEmpty
    private List<Column> columns;
    @JsonIgnore
    private Map<String, Column> columnMap;

    public void setColumns(List<Column> columns) {
        this.columns = columns;
        this.columnMap = columns.stream().collect(Collectors.toMap(Column::getData, x -> x));
    }

    public Optional<Column> getColumn(String columnName) {
        return Optional.ofNullable(this.columnMap.get(columnName));
    }

    public int getDraw() {
        return this.draw;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public Search getSearch() {
        return this.search;
    }

    public List<Order> getOrder() {
        return this.order;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    public void setDraw(int draw) {
        this.draw = draw;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setSearch(Search search) {
        this.search = search;
    }

    public void setOrder(List<Order> order) {
        this.order = order;
    }

    public void setColumnMap(Map<String, Column> columnMap) {
        this.columnMap = columnMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTablesInput)) {
            return false;
        }
        DataTablesInput other = (DataTablesInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDraw() != other.getDraw()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        Search this$search = this.getSearch();
        Search other$search = other.getSearch();
        if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
            return false;
        }
        List<Order> this$order = this.getOrder();
        List<Order> other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, Column> this$columnMap = this.getColumnMap();
        Map<String, Column> other$columnMap = other.getColumnMap();
        return !(this$columnMap == null ? other$columnMap != null : !((Object)this$columnMap).equals(other$columnMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTablesInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDraw();
        result = result * 59 + this.getStart();
        result = result * 59 + this.getLength();
        Search $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
        List<Order> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, Column> $columnMap = this.getColumnMap();
        result = result * 59 + ($columnMap == null ? 43 : ((Object)$columnMap).hashCode());
        return result;
    }

    public String toString() {
        return "DataTablesInput(draw=" + this.getDraw() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", search=" + this.getSearch() + ", order=" + this.getOrder() + ", columns=" + this.getColumns() + ", columnMap=" + this.getColumnMap() + ")";
    }

    public static final class Order {
        @Min(value=0L)
        private @Min(value=0L) int column;
        @NotNull
        private Direction dir;

        public Order(@Min(value=0L) @Min(value=0L) int column, @NotNull Direction dir) {
            this.column = column;
            this.dir = dir;
        }

        Order() {
        }

        public int getColumn() {
            return this.column;
        }

        public Direction getDir() {
            return this.dir;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public void setDir(Direction dir) {
            this.dir = dir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Order)) {
                return false;
            }
            Order other = (Order)o;
            if (this.getColumn() != other.getColumn()) {
                return false;
            }
            Direction this$dir = this.getDir();
            Direction other$dir = other.getDir();
            return !(this$dir == null ? other$dir != null : !((Object)((Object)this$dir)).equals((Object)other$dir));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColumn();
            Direction $dir = this.getDir();
            result = result * 59 + ($dir == null ? 43 : ((Object)((Object)$dir)).hashCode());
            return result;
        }

        public String toString() {
            return "DataTablesInput.Order(column=" + this.getColumn() + ", dir=" + (Object)((Object)this.getDir()) + ")";
        }

        public static enum Direction {
            desc,
            asc;

        }
    }

    public static final class Search {
        @NotNull
        private String value;
        private boolean regex;

        public Search(@NotNull String value, boolean regex) {
            this.value = value;
            this.regex = regex;
        }

        Search() {
        }

        public String getValue() {
            return this.value;
        }

        public boolean isRegex() {
            return this.regex;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setRegex(boolean regex) {
            this.regex = regex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Search)) {
                return false;
            }
            Search other = (Search)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            return this.isRegex() == other.isRegex();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            result = result * 59 + (this.isRegex() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "DataTablesInput.Search(value=" + this.getValue() + ", regex=" + this.isRegex() + ")";
        }
    }

    public static final class Column {
        @NotBlank
        private String data;
        private String name;
        private boolean searchable;
        private boolean orderable;
        @NotNull
        private Search search;

        public String getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public boolean isOrderable() {
            return this.orderable;
        }

        public Search getSearch() {
            return this.search;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSearchable(boolean searchable) {
            this.searchable = searchable;
        }

        public void setOrderable(boolean orderable) {
            this.orderable = orderable;
        }

        public void setSearch(Search search) {
            this.search = search;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.isSearchable() != other.isSearchable()) {
                return false;
            }
            if (this.isOrderable() != other.isOrderable()) {
                return false;
            }
            Search this$search = this.getSearch();
            Search other$search = other.getSearch();
            return !(this$search == null ? other$search != null : !((Object)this$search).equals(other$search));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + (this.isSearchable() ? 79 : 97);
            result = result * 59 + (this.isOrderable() ? 79 : 97);
            Search $search = this.getSearch();
            result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
            return result;
        }

        public String toString() {
            return "DataTablesInput.Column(data=" + this.getData() + ", name=" + this.getName() + ", searchable=" + this.isSearchable() + ", orderable=" + this.isOrderable() + ", search=" + this.getSearch() + ")";
        }
    }
}

