/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.datatables;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.datatables.DataTablesCriteria;
import org.springframework.data.mongodb.datatables.DataTablesInput;
import org.springframework.data.mongodb.datatables.DataTablesOutput;
import org.springframework.data.mongodb.datatables.DataTablesRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;

final class DataTablesRepositoryImpl<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements DataTablesRepository<T, ID> {
    private final MongoEntityInformation<T, ID> metadata;
    private final MongoOperations mongoOperations;

    public DataTablesRepositoryImpl(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.metadata = metadata;
        this.mongoOperations = mongoOperations;
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input) {
        return this.findAll(input, null, null, null);
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input, Criteria additionalCriteria) {
        return this.findAll(input, additionalCriteria, null, null);
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input, Criteria additionalCriteria, Criteria preFilteringCriteria) {
        return this.findAll(input, additionalCriteria, preFilteringCriteria, null);
    }

    @Override
    public <R> DataTablesOutput<R> findAll(DataTablesInput input, Function<T, R> converter) {
        return this.findAll(input, null, null, converter);
    }

    @Override
    public <R> DataTablesOutput<R> findAll(DataTablesInput input, Criteria additionalCriteria, Criteria preFilteringCriteria, Function<T, R> converter) {
        DataTablesOutput output = new DataTablesOutput();
        output.setDraw(input.getDraw());
        if (input.getLength() == 0) {
            return output;
        }
        try {
            long recordsTotal = this.count(preFilteringCriteria);
            output.setRecordsTotal(recordsTotal);
            if (recordsTotal == 0L) {
                return output;
            }
            Query query = new DataTablesCriteria(input, additionalCriteria, preFilteringCriteria).toQuery();
            long recordsFiltered = this.mongoOperations.count(query, this.metadata.getCollectionName());
            output.setRecordsFiltered(recordsFiltered);
            if (recordsFiltered == 0L) {
                return output;
            }
            List data = this.mongoOperations.find(query, this.metadata.getJavaType(), this.metadata.getCollectionName());
            output.setData(converter == null ? data : data.stream().map(converter).collect(Collectors.toList()));
        }
        catch (Exception e) {
            output.setError(e.toString());
        }
        return output;
    }

    private long count(Criteria preFilteringCriteria) {
        if (preFilteringCriteria == null) {
            return this.count();
        }
        return this.mongoOperations.count(Query.query((CriteriaDefinition)preFilteringCriteria), this.metadata.getCollectionName());
    }
}

