/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.repository;

import java.util.Arrays;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.parameter.ColumnParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

public class DataTablesSpecification<T>
implements Specification<T> {
    private static final String OR_SEPARATOR = "+";
    private static final String ATTRIBUTE_SEPARATOR = ".";
    private final DataTablesInput input;

    public DataTablesSpecification(DataTablesInput input) {
        this.input = input;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Predicate predicate = criteriaBuilder.conjunction();
        for (ColumnParameter column : this.input.getColumns()) {
            String filterValue = column.getSearch().getValue();
            if (!column.getSearchable().booleanValue() || !StringUtils.hasText((String)filterValue)) continue;
            Expression<String> expression = this.getExpression(root, column.getData());
            if (filterValue.contains(OR_SEPARATOR)) {
                String[] values = filterValue.split("\\+");
                if (values.length > 0 && this.isBoolean(values[0])) {
                    Object[] booleanValues = new Boolean[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        booleanValues[i] = Boolean.valueOf(values[i]);
                    }
                    predicate = criteriaBuilder.and((Expression)predicate, (Expression)expression.as(Boolean.class).in(booleanValues));
                    continue;
                }
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)expression.in(Arrays.asList(values)));
                continue;
            }
            if (this.isBoolean(filterValue)) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal(expression.as(Boolean.class), (Object)Boolean.valueOf(filterValue)));
                continue;
            }
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.like(criteriaBuilder.lower(expression), "%" + filterValue.toLowerCase() + "%"));
        }
        String globalFilterValue = this.input.getSearch().getValue();
        if (StringUtils.hasText((String)globalFilterValue)) {
            Predicate matchOneColumnPredicate = criteriaBuilder.disjunction();
            for (ColumnParameter column : this.input.getColumns()) {
                if (!column.getSearchable().booleanValue()) continue;
                Expression<String> expression = this.getExpression(root, column.getData());
                matchOneColumnPredicate = criteriaBuilder.or((Expression)matchOneColumnPredicate, (Expression)criteriaBuilder.like(criteriaBuilder.lower(expression), "%" + globalFilterValue.toLowerCase() + "%"));
            }
            predicate = criteriaBuilder.and((Expression)predicate, (Expression)matchOneColumnPredicate);
        }
        return predicate;
    }

    private boolean isBoolean(String filterValue) {
        return "TRUE".equalsIgnoreCase(filterValue) || "FALSE".equalsIgnoreCase(filterValue);
    }

    private Expression<String> getExpression(Root<T> root, String columnData) {
        if (columnData.contains(ATTRIBUTE_SEPARATOR)) {
            String[] values = columnData.split("\\.");
            return root.join(values[0], JoinType.LEFT).get(values[1]).as(String.class);
        }
        return root.get(columnData).as(String.class);
    }
}

