/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.repository;

import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.mapping.DataTablesOutput;
import org.springframework.data.jpa.datatables.parameter.ColumnParameter;
import org.springframework.data.jpa.datatables.parameter.OrderParameter;
import org.springframework.data.jpa.datatables.repository.DataTablesRepository;
import org.springframework.data.jpa.datatables.repository.DataTablesSpecification;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class DataTablesRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements DataTablesRepository<T, ID> {
    public DataTablesRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input) {
        return this.findAll(input, null);
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input, Specification<T> additionalSpecification) {
        DataTablesOutput output = new DataTablesOutput();
        output.setDraw(input.getDraw());
        try {
            output.setRecordsTotal(this.count());
            Page data = this.findAll((Specification)Specifications.where(new DataTablesSpecification(input)).and(additionalSpecification), this.getPageable(input));
            output.setData(data.getContent());
            output.setRecordsFiltered(data.getTotalElements());
        }
        catch (Exception e) {
            output.setError(e.toString());
            output.setRecordsFiltered(0L);
        }
        return output;
    }

    private Pageable getPageable(DataTablesInput input) {
        Sort sort;
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (OrderParameter order : input.getOrder()) {
            ColumnParameter column = input.getColumns().get(order.getColumn());
            if (!column.getOrderable().booleanValue()) continue;
            String sortColumn = column.getData();
            Sort.Direction sortDirection = Sort.Direction.fromString((String)order.getDir());
            orders.add(new Sort.Order(sortDirection, sortColumn));
        }
        Sort sort2 = sort = orders.isEmpty() ? null : new Sort(orders);
        if (input.getLength() == -1) {
            input.setStart(0);
            input.setLength(Integer.MAX_VALUE);
        }
        return new PageRequest(input.getStart() / input.getLength(), input.getLength().intValue(), sort);
    }
}

