/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.validator.constraint.number;

import com.github.damianwajser.validator.annotation.number.Digits;
import com.github.damianwajser.validator.constraint.AbstractConstraint;
import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DigitsConstraint
extends AbstractConstraint
implements ConstraintValidator<Digits, Object> {
    int maxIntegerLength;
    int maxFractionLength;

    public void initialize(Digits field) {
        this.excludes = field.excludes();
        this.isNulleable = field.isNulleable();
        this.maxIntegerLength = field.integer();
        this.maxFractionLength = field.fraction();
        this.validateParameters();
    }

    @Override
    protected boolean hasError(Object field, ConstraintValidatorContext cxt) {
        BigDecimal bigNum = field != null && field.getClass().isAssignableFrom(BigDecimal.class) ? (BigDecimal)field : new BigDecimal(field.toString()).stripTrailingZeros();
        int integerPartLength = bigNum.precision() - bigNum.scale();
        int fractionPartLength = bigNum.scale() < 0 ? 0 : bigNum.scale();
        return this.maxIntegerLength < integerPartLength || this.maxFractionLength < fractionPartLength;
    }

    private void validateParameters() {
        if (this.maxIntegerLength < 0) {
            throw new IllegalArgumentException("The length of the integer part cannot be negative.");
        }
        if (this.maxFractionLength < 0) {
            throw new IllegalArgumentException("The length of the fraction part cannot be negative.");
        }
    }
}

