package com.github.damianwajser.generators;

import com.github.damianwajser.configuration.PropertiesLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.UUID;

@Component
public class TraceIdGenerator implements RequestIdGenerator {

	private static final Logger LOGGER = LoggerFactory.getLogger(TraceIdGenerator.class);

	@Autowired
	private PropertiesLogger properties;

	@Override
	public String getRequestId(HttpServletRequest request) {
		//El api gateway tiene que agregar el Correlation Id
		String traceValue = request.getHeader(properties.getTraceId());
		if (StringUtils.isEmpty(traceValue)) {
			LOGGER.warn("Request Id not present in request,one autogenerated, please configure your api gateway to generate trace-id");
			traceValue = UUID.randomUUID().toString();
		}
		return traceValue;
	}
}
