/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.filter;

import com.github.damianwajser.configuration.PropertiesLogger;
import com.github.damianwajser.generators.RequestIdGenerator;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483648)
public class MDCFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCFilter.class);
    @Autowired
    private PropertiesLogger properties;
    @Autowired
    private RequestIdGenerator generator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            MDC.put((String)"clientIp", (String)request.getRemoteAddr());
            MDC.put((String)"appName", (String)this.properties.getAppName());
            if (HttpServletRequest.class.isAssignableFrom(request.getClass())) {
                MDC.put((String)"requestId", (String)this.generator.getRequestId(request));
                Enumeration headers = request.getHeaderNames();
                while (headers.hasMoreElements()) {
                    String headerName = (String)headers.nextElement();
                    String headerValue = request.getHeader(headerName);
                    if (headerValue == null || !headerName.toUpperCase().startsWith("X-")) continue;
                    MDC.put((String)headerName, (String)headerValue);
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.clear();
        }
    }

    public void destroy() {
        MDC.clear();
    }
}

