/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.configuration;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConfigurationProperties
@PropertySource(value={"classpath:spring-commons-logger.properties"})
public class PropertiesLogger {
    private static final Map<String, String> propertiesToShow = new HashMap<String, String>();
    public static final String APP_NAME = "APP_NAME";
    @Value(value="${spring.commons.logger.trace.id}")
    private String traceId;
    @Value(value="${spring.commons.logger.app.name}")
    private String appName;
    @Value(value="${spring.commons.logger.payload.max}")
    private Integer maxPayLoad;

    public Integer getMaxPayLoad() {
        return this.maxPayLoad;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getAppName() {
        return this.appName;
    }

    public Map<String, String> getPropetiesToShow() {
        if (propertiesToShow.isEmpty()) {
            propertiesToShow.put(APP_NAME, this.getAppName());
        }
        return propertiesToShow;
    }
}

