/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.generators;

import com.github.damianwajser.configuration.PropertiesLogger;
import com.github.damianwajser.generators.RequestIdGenerator;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TraceIdGenerator
implements RequestIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceIdGenerator.class);
    @Autowired
    private PropertiesLogger properties;

    @Override
    public String getRequestId(HttpServletRequest request) {
        String traceValue = request.getHeader(this.properties.getTraceId());
        if (StringUtils.isEmpty((Object)traceValue)) {
            LOGGER.warn("Request Id not present in request,one autogenerated, please configure your api gateway to generate trace-id");
            traceValue = UUID.randomUUID().toString();
        }
        return traceValue;
    }
}

