/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.configuration;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.damianwajser.configuration.PropertiesLogger;
import javax.annotation.PostConstruct;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"spring.commons.logstash.enabled"}, havingValue="true")
public class LogstashConfiguration {
    @Value(value="${spring.commons.logstash.destination:localhost:5000}")
    private String destination;
    @Autowired
    private PropertiesLogger propertiesLogger;

    @PostConstruct
    public void init() {
        ObjectMapper mapper = new ObjectMapper();
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        Logger log = loggerContext.getLogger(LogstashConfiguration.class);
        log.info("Configurate  Logger, destination: {}", (Object)this.destination);
        if (this.destination != null && !this.destination.equals("")) {
            LogstashTcpSocketAppender socketAppender = new LogstashTcpSocketAppender();
            socketAppender.setName("logstash");
            socketAppender.setContext((Context)loggerContext);
            socketAppender.addDestination(this.destination);
            LogstashEncoder encoder = new LogstashEncoder();
            encoder.setContext((Context)loggerContext);
            try {
                encoder.setCustomFields(mapper.writeValueAsString((Object)this.propertiesLogger.getPropetiesToShow()));
            }
            catch (JsonProcessingException e) {
                encoder.setCustomFields("{ APP_NAME: \"" + this.propertiesLogger.getAppName() + "\" }");
            }
            encoder.start();
            socketAppender.setEncoder((Encoder)encoder);
            socketAppender.start();
            AsyncAppender asyncAppender = new AsyncAppender();
            asyncAppender.addAppender((Appender)socketAppender);
            asyncAppender.start();
            rootLogger.addAppender((Appender)asyncAppender);
        }
    }
}

