/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.idempotency.generators;

import com.github.damianwajser.idempotency.exception.ArgumentNotFoundException;
import com.github.damianwajser.idempotency.generators.IdempotencyKeyGenerator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

public class DefaultIdempotencyKeyGenerator
implements IdempotencyKeyGenerator<Object> {
    private static final String IDEMPOTENCY_DEFALUT_HEADER = "X-Idempotency-Key";

    @Override
    public String generateKey(HttpHeaders headers, HttpMethod method, String path, Object request) {
        String key = this.getHeaderValue(headers, IDEMPOTENCY_DEFALUT_HEADER);
        return path + "::" + key + "::" + method.toString();
    }

    protected String getHeaderValue(HttpHeaders headers, String headerKey) {
        List idempotencyHeader = headers.get((Object)headerKey);
        if (idempotencyHeader == null) {
            throw new ArgumentNotFoundException(headerKey);
        }
        String key = idempotencyHeader.stream().collect(Collectors.joining("::"));
        return key;
    }
}

