/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.idempotency.filters;

import com.github.damianwajser.exceptions.RestException;
import com.github.damianwajser.exceptions.impl.badrequest.BadRequestException;
import com.github.damianwajser.exceptions.impl.badrequest.ConflictException;
import com.github.damianwajser.idempotency.configuration.IdempotencyEndpoints;
import com.github.damianwajser.idempotency.configuration.IdempotencyProperties;
import com.github.damianwajser.idempotency.exception.ArgumentNotFoundException;
import com.github.damianwajser.idempotency.exception.RedisException;
import com.github.damianwajser.idempotency.model.StoredResponse;
import com.github.damianwajser.idempotency.utils.HeadersUtil;
import com.github.damianwajser.idempotency.utils.JsonUtils;
import com.github.damianwajser.idempotency.writers.HttpServletResponseCopier;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class IdempontecyFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempontecyFilter.class);
    private static final String ERROR_REDIS = "Error Redis retrive information to key: {}";
    private final IdempotencyProperties idempotencyProperties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final IdempotencyEndpoints idempotencyEndpoints;

    public IdempontecyFilter(RedisTemplate<String, Object> redisTemplate, IdempotencyEndpoints idempotencyEndpoints, IdempotencyProperties properties) {
        Assert.notNull(redisTemplate, (String)"redisTemplate is required");
        Assert.notEmpty((Object[])idempotencyEndpoints.getUrlPatterns(), (String)"No Pattterns are configured");
        this.idempotencyProperties = properties;
        this.redisTemplate = redisTemplate;
        this.idempotencyEndpoints = idempotencyEndpoints;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug("IdempontecyFilter initialize");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.idempotencyEndpoints.isApplicable(request)) {
            this.executeIdempotency(chain, request, response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void executeIdempotency(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block6: {
            try {
                String key = this.getKey(request, this.idempotencyEndpoints);
                LOGGER.info("try lock request key: {}", (Object)key);
                Boolean notExistInRedis = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)new StoredResponse(), this.idempotencyProperties.getIdempotencyTtl(), TimeUnit.MILLISECONDS);
                if (notExistInRedis != null) {
                    if (notExistInRedis.booleanValue()) {
                        this.excecuteRequest(chain, request, response, key);
                    } else {
                        this.excecuteIdempotency(response, request, key);
                    }
                    break block6;
                }
                LOGGER.error(ERROR_REDIS, (Object)key);
                throw new RedisException(String.format(ERROR_REDIS, key));
            }
            catch (ArgumentNotFoundException e) {
                this.writeBadRequestMessage(response, request, e);
            }
            catch (Exception e) {
                LOGGER.error("Error to parser", (Throwable)e);
            }
        }
    }

    private void excecuteRequest(FilterChain chain, HttpServletRequest request, HttpServletResponse response, String key) {
        LOGGER.info("firts Time for these request, lock key: {}", (Object)key);
        try {
            HttpServletResponseCopier responseCopier = new HttpServletResponseCopier(response);
            LOGGER.info("Call the real controller");
            chain.doFilter((ServletRequest)request, (ServletResponse)responseCopier);
            byte[] copy = responseCopier.getCopy();
            String value = new String(copy);
            StoredResponse storeObject = new StoredResponse(value, new HeadersUtil().getHeadersMap(response), response.getStatus(), false);
            LOGGER.info("store request key: {} - value: {}", (Object)key, (Object)storeObject);
            this.redisTemplate.opsForValue().set((Object)key, (Object)storeObject);
            LOGGER.info("set expiration - request key: {} ttl: ", (Object)key);
            this.redisTemplate.expire((Object)key, this.idempotencyProperties.getIdempotencyTtl(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("Error to save idempotency response in redis", (Throwable)e);
        }
    }

    private void excecuteIdempotency(HttpServletResponse response, HttpServletRequest request, String key) throws IOException, ServletException {
        StoredResponse previusResponse = (StoredResponse)this.redisTemplate.opsForValue().get((Object)key);
        LOGGER.info("retrive key: {} to cache, body: {}", (Object)key, (Object)previusResponse);
        if (previusResponse != null) {
            if (!previusResponse.isLocked()) {
                this.writeResponse(response, previusResponse, true);
            } else {
                this.writeLockMessage(response, request);
            }
        } else {
            LOGGER.error(ERROR_REDIS, (Object)key);
            throw new RedisException(String.format(ERROR_REDIS, key));
        }
    }

    private void writeBadRequestMessage(HttpServletResponse response, HttpServletRequest request, ArgumentNotFoundException e) throws IOException {
        BadRequestException message = new BadRequestException(this.idempotencyProperties.getBadRequestCode(), e.getArgument() + " Not Found", Optional.empty());
        this.writeErrorMessage(response, (RestException)message, request, HttpStatus.BAD_REQUEST);
    }

    private void writeLockMessage(HttpServletResponse response, HttpServletRequest request) throws IOException {
        ConflictException message = new ConflictException(this.idempotencyProperties.getConflictCode(), this.idempotencyProperties.getConflictMessage(), Optional.empty());
        this.writeErrorMessage(response, (RestException)message, request, HttpStatus.CONFLICT);
    }

    private void writeErrorMessage(HttpServletResponse response, RestException exception, HttpServletRequest request, HttpStatus status) throws IOException {
        this.writeResponse(response, new StoredResponse(new JsonUtils().objectToJsonString(exception.getErrorMessage(request)), null, status.value()), false);
    }

    private String getKey(HttpServletRequest request, IdempotencyEndpoints idempotencyEndpoints) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return idempotencyEndpoints.generateKey(request);
    }

    private HttpServletResponseCopier writeResponse(HttpServletResponse response, StoredResponse message, boolean cached) throws IOException {
        HttpServletResponseCopier wrapper = new HttpServletResponseCopier(response);
        PrintWriter responseWriter = response.getWriter();
        CharArrayWriter charWriter = new CharArrayWriter();
        charWriter.write(message.getBody());
        String alteredContent = charWriter.toString();
        response.setContentLength(alteredContent.length());
        response.setStatus(message.getStatusCode());
        response.setHeader("Content-Type", "application/json");
        response.setHeader("X-Idempotency", String.valueOf(cached));
        responseWriter.write(alteredContent);
        return wrapper;
    }

    public void destroy() {
    }
}

