/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.exceptions.handlers;

import com.github.damianwajser.exceptions.model.ExceptionDetail;
import java.util.Map;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;

public final class FieldErrorMapper {
    private FieldErrorMapper() {
    }

    public static ExceptionDetail convert(FieldError error) {
        Map attributes = ((ConstraintViolation)error.unwrap(ConstraintViolation.class)).getConstraintDescriptor().getAttributes();
        String code = HttpStatus.BAD_GATEWAY.toString();
        if (attributes != null) {
            code = attributes.getOrDefault("businessCode", "400").toString();
        }
        ExceptionDetail detail = new ExceptionDetail(code, error.getDefaultMessage(), Optional.of(error.getField()));
        detail.setMetaData("rejectedValue", error.getRejectedValue());
        detail.setMetaData("field", (Object)error.getField());
        detail.setMetaData("reason", (Object)error.getCode());
        return detail;
    }
}

