/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.exceptions.handlers;

import com.github.damianwajser.exceptions.RestException;
import com.github.damianwajser.exceptions.handlers.FieldErrorMapper;
import com.github.damianwajser.exceptions.model.ErrorMessage;
import com.github.damianwajser.exceptions.model.ExceptionDetail;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    @Autowired
    private MessageSource messageSource;

    @ExceptionHandler(value={RestException.class})
    protected ResponseEntity<ErrorMessage> handleConflict(RestException ex, HttpServletRequest request, Locale locale) {
        return new ResponseEntity((Object)new ErrorMessage(this.getExceptionDetails(ex, locale), request), ex.getHttpCode());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ErrorMessage> handleValidationExceptions(MethodArgumentNotValidException ex, HttpServletRequest request) {
        return this.validationBinnding(ex.getBindingResult(), request);
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<ErrorMessage> handleValidationExceptions(BindException ex, HttpServletRequest request) {
        return this.validationBinnding(ex.getBindingResult(), request);
    }

    private ResponseEntity<ErrorMessage> validationBinnding(BindingResult results, HttpServletRequest request) {
        return new ResponseEntity((Object)new ErrorMessage(this.getExceptionDetails(results), request), HttpStatus.BAD_REQUEST);
    }

    private List<ExceptionDetail> getExceptionDetails(BindingResult results) {
        return results.getFieldErrors().stream().map(FieldErrorMapper::convert).collect(Collectors.toList());
    }

    private List<ExceptionDetail> getExceptionDetails(RestException ex, Locale locale) {
        return ex.getDetails().stream().map(d -> FieldErrorMapper.internacionalizate(d, this.messageSource, locale)).collect(Collectors.toList());
    }
}

