/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.actuator.enpoints;

import com.github.damianwajser.utilities.CacheUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Endpoint(id="cache-keys")
public class CacheKeysEndpoint {
    @Autowired
    private RedisTemplate redisTemplate;

    @ReadOperation
    public Map<String, Object> keys() {
        return CacheUtilities.getKeysInformation(this.redisTemplate, "");
    }

    @ReadOperation
    public Map<String, Object> key(@Selector String key) {
        return CacheUtilities.getKeysInformation(this.redisTemplate, key).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::getCacheInfo));
    }

    private Map<String, Object> getCacheInfo(Map.Entry<String, Object> entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", entry.getValue());
        map.put("ttl", this.redisTemplate.opsForValue().getOperations().getExpire((Object)entry.getKey()));
        return map;
    }

    @DeleteOperation
    public boolean delete(@Selector String key) {
        return this.redisTemplate.opsForValue().getOperations().delete((Object)key);
    }
}

