/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.core.RedisTemplate;

public final class CacheUtilities {
    public static Map<String, Object> getKeysInformation(RedisTemplate redisTemplate, String cache) {
        HashSet keys = redisTemplate != null ? redisTemplate.keys((Object)(cache + "*")) : new HashSet();
        return keys.isEmpty() ? new HashMap<String, Object>() : keys.stream().collect(Collectors.toMap(Object::toString, k -> redisTemplate.opsForValue().get(k)));
    }

    public static Optional<RedisCache> getRedisCache(CacheManager cacheManager, String name) {
        Cache cacheImpl;
        Optional<RedisCache> redisCache = Optional.empty();
        if (cacheManager != null && TransactionAwareCacheDecorator.class.isAssignableFrom((cacheImpl = cacheManager.getCache(name)).getClass()) && RedisCache.class.isAssignableFrom((cacheImpl = ((TransactionAwareCacheDecorator)cacheImpl).getTargetCache()).getClass())) {
            redisCache = Optional.of((RedisCache)cacheImpl);
        }
        return redisCache;
    }
}

