/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.actuator.extension;

import com.github.damianwajser.model.CacheInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.cache.CachesEndpoint;
import org.springframework.boot.actuate.cache.CachesEndpointWebExtension;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Primary
@Component
@EndpointWebExtension(endpoint=CachesEndpoint.class)
public class CacheEndpointExtension
extends CachesEndpointWebExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheEndpointExtension.class);
    @Autowired(required=false)
    private CacheManager cache;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    public CacheEndpointExtension(CachesEndpoint delegate) {
        super(delegate);
        LOGGER.debug("inicializando extencion actuator");
    }

    @ReadOperation
    public WebEndpointResponse<CacheInfo> cache(@Selector String cache, @Selector String detail, @Nullable String cacheManager) {
        LOGGER.info("call to cache extension");
        WebEndpointResponse cacheEntry = super.cache(cache, cacheManager);
        CacheInfo info = new CacheInfo();
        if (cacheEntry.getStatus() == 200) {
            Optional<RedisCache> redisCache = this.getRedisCache(((CachesEndpoint.CacheEntry)cacheEntry.getBody()).getName());
            redisCache.ifPresent(c -> {
                info.setTtl(c.getCacheConfiguration().getTtl().getSeconds() + " seconds");
                String prefix = c.getCacheConfiguration().getKeyPrefixFor(cache);
                info.setPrerfix(prefix);
                info.setKeys(this.getKeysInformation(cache));
            });
        }
        LOGGER.info("response cache info {}", (Object)info);
        return new WebEndpointResponse((Object)info, 200);
    }

    private Map<String, Object> getKeysInformation(String cache) {
        HashSet keys = this.redisTemplate != null ? this.redisTemplate.keys((Object)(cache + "*")) : new HashSet();
        return keys.isEmpty() ? null : keys.stream().collect(Collectors.toMap(Object::toString, k -> this.redisTemplate.opsForValue().get(k)));
    }

    private Optional<RedisCache> getRedisCache(String name) {
        Cache cacheImpl;
        Optional<RedisCache> redisCache = Optional.empty();
        if (this.cache != null && TransactionAwareCacheDecorator.class.isAssignableFrom((cacheImpl = this.cache.getCache(name)).getClass()) && RedisCache.class.isAssignableFrom((cacheImpl = ((TransactionAwareCacheDecorator)cacheImpl).getTargetCache()).getClass())) {
            redisCache = Optional.of((RedisCache)cacheImpl);
        }
        return redisCache;
    }
}

