package com.crabshue.commons.http.client.ssl;

import java.io.File;

import org.glassfish.jersey.SslConfigurator;

public class SslOptionsBuilder {

    private String securityProtocol = "SSL";

    private File keyStoreFile;

    private String keyStorePassword;

    private String keyStoreType = "JKS";

    private File trustStoreFile;

    private String trustStorePassword;


    public static SslOptionsBuilder standard() {
        return new SslOptionsBuilder();
    }


    public SslOptionsBuilder withSecurityProtocol(final String securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    public SslOptionsBuilder withKeyStoreFile(final File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        return this;
    }

    public SslOptionsBuilder withKeyStorePassword(final String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslOptionsBuilder withKeyStoreType(final String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public SslOptionsBuilder withTrustStoreFile(final File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        return this;
    }

    public SslOptionsBuilder withTrustStorePassword(final String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }


    public SslOptions build() {
        final SslConfigurator sslConfigurator = SslConfigurator.newInstance();

        sslConfigurator.securityProtocol(this.securityProtocol);

        if (keyStoreFile != null) {
            sslConfigurator.keyStoreFile(this.keyStoreFile.getAbsolutePath())
                .keyStorePassword(this.keyStorePassword)
                .keyStoreType(this.keyStoreType);
        }

        if (this.trustStoreFile != null) {
            sslConfigurator.trustStoreFile(this.trustStoreFile.getAbsolutePath())
                .trustStorePassword(this.trustStorePassword);
        }

        SslOptions sslOptions = new SslOptions();
        sslOptions.setSslContext(sslConfigurator.createSSLContext());
        return sslOptions;
    }
}
