package com.crabshue.commons.http.client.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import javax.net.ssl.SSLContext;

import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.CommonErrorContext;
import com.crabshue.commons.http.client.exceptions.HttpClientErrorType;
import lombok.Data;

@Data
public class SslOptions {

    public static SslOptions defaultSslOptions() {
        return new SslOptions();
    }

    private SSLContext sslContext;

    public SslOptions() {
        try {
            this.sslContext = SSLContext.getInstance("SSL");
            this.sslContext.init(null, null, new SecureRandom());
        } catch (NoSuchAlgorithmException e) {
            throw new SystemException(HttpClientErrorType.SSL_CONTEXT_UNKNOWN_INSTANCE, e)
                .addContextValue(CommonErrorContext.CAUSE, "SSL");
        } catch (KeyManagementException e) {
            throw new SystemException(HttpClientErrorType.CANNOT_INITIALIZE_SSL_CONTEXT, e);
        }
    }
}
