package com.crabshue.commons.http.client.response;

import javax.ws.rs.core.Response;

import com.crabshue.commons.exceptions.ApplicationException;
import com.crabshue.commons.http.client.exceptions.HttpClientErrorContext;
import com.crabshue.commons.http.client.exceptions.HttpClientErrorType;
import lombok.NonNull;

public class HttpResponseReader {

    public static <T> T readResponseBody(@NonNull final Response response,
                                         @NonNull final Class<T> clazz) {

        try {
            return response.readEntity(clazz);
        } catch (Exception e) {
            throw new ApplicationException(HttpClientErrorType.CANNOT_READ_RESPONSE, e)
                .addContextValue(HttpClientErrorContext.RESPONSE, response);
        }
    }

}
