package com.crabshue.commons.http.client.cookie;

import java.util.Map;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

import com.crabshue.commons.exceptions.ApplicationException;
import com.crabshue.commons.http.client.exceptions.HttpClientErrorContext;
import com.crabshue.commons.http.client.exceptions.HttpClientErrorType;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public final class CookieUtils {

    public static Cookie retrieveSessionCookieFromHeader(@NonNull final Response response,
                                                         @NonNull final String cookieName) {

        final Map<String, NewCookie> cookies = response.getCookies();
        final NewCookie cookie = cookies.get(cookieName);
        if (cookie == null) {
            throw new ApplicationException(HttpClientErrorType.NO_COOKIE_IN_RESPONSE)
                .addContextValue(HttpClientErrorContext.RESPONSE, response);
        }

        logger.info("Extracted cookie [{}] from response [{}]", cookie, response);
        return cookie;
    }

    private CookieUtils() {
    }


}
