package com.crabshue.commons.http.client.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

import org.glassfish.jersey.client.ClientProperties;

import com.crabshue.commons.http.client.ssl.SslOptions;

/**
 * {@link Client} builder.
 */
public class JerseyClientBuilder {

    /**
     * Build a {@link Client} with {@link ClientOptions#defaultClientOptions()}.
     *
     * @return the client.
     * @see #newClient(ClientOptions)
     */
    public static Client newClient() {
        return newClient(ClientOptions.defaultClientOptions());
    }

    /**
     * Build a {@link Client} with a {@link ClientOptions}.
     *
     * @param clientOptions the client options.
     * @return the client.
     */
    public static Client newClient(final ClientOptions clientOptions) {
        return newClient(clientOptions, null);
    }

    public static Client newClient(final ClientOptions clientOptions, final SslOptions sslOptions) {
        final Client ret;
        if (sslOptions != null) {
            final ClientBuilder retBuilder = ClientBuilder.newBuilder();
            ret = retBuilder.sslContext(sslOptions.getSslContext()).build();
        } else {
            ret = ClientBuilder.newClient();
        }
        ret.property(ClientProperties.FOLLOW_REDIRECTS, clientOptions.isFollowRedirects());
        ret.property(ClientProperties.CONNECT_TIMEOUT, clientOptions.getConnectionTimeOutInMilliseconds());
        ret.property(ClientProperties.READ_TIMEOUT, clientOptions.getReadTimeoutInMilliseconds());
        return ret;
    }
}
