package com.crabshue.commons.http.client.client;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import javax.ws.rs.core.Response;

import lombok.Data;
import lombok.NonNull;

/**
 * Client options for configuringa {@link javax.ws.rs.client.Client}.
 * <p>Default options are:</p>
 * <ul>
 * <li>follow redirects : true</li>
 * <li>connection timeout : 0 ms</li>
 * <li>read timeout : 0 ms</li>
 * </ul>
 *
 */
@Data
public class ClientOptions {

    public static ClientOptions defaultClientOptions() {
        return new ClientOptions();
    }

    private boolean followRedirects = true;

    private int connectionTimeOutInMilliseconds = 0;

    private int readTimeoutInMilliseconds = 0;

    // response statuses that will trigger a retry
    private Collection<Response.Status> statusesForRetry = new ArrayList<>();

    public ClientOptions addStatusesForRetry(@NonNull final Response.Status... statuses) {

        this.statusesForRetry.addAll(Arrays.asList(statuses));
        return this;
    }
}
