package com.crabshue.commons.http.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import javax.ws.rs.HttpMethod;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

import lombok.Data;

/**
 * Definition for an HTTP request. Executed by {@link HttpClient}.
 */
@Data
public class HttpRequest {

    private String httpMethod;

    private String requestBaseUrl;

    private String resourcePath;

    private MediaType mediaType = MediaType.WILDCARD_TYPE;

    private Object entity;

    private MediaType entityMediaType;

    private MultivaluedMap<String, Object> headers = new MultivaluedHashMap<>();

    private Collection<Cookie> cookies = new ArrayList<>();

    private Map<String, String> queryParameters = new HashMap<>();

    public HttpRequest get() {
        return this.setHttpMethod(HttpMethod.GET);
    }

    public HttpRequest post() {
        return this.setHttpMethod(HttpMethod.POST);
    }

    public HttpRequest delete() {
        return this.setHttpMethod(HttpMethod.DELETE);
    }

    public HttpRequest put() {
        return this.setHttpMethod(HttpMethod.PUT);
    }

    public HttpRequest head() {
        return this.setHttpMethod(HttpMethod.HEAD);
    }

    public Optional<Object> getEntity() {
        return Optional.ofNullable(entity);
    }

    public HttpRequest addHeaders(final String key, final Object... values) {
        this.headers.addAll(key, values);
        return this;
    }

    public HttpRequest addCookie(final Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public HttpRequest addQueryParameter(final String parameterName, final String parameterValue) {
        this.queryParameters.put(parameterName, parameterValue);
        return this;
    }
}
