/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import java.io.IOException;
import java.net.URI;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqRequestLine;
import org.takes.rs.RsRedirect;
import org.takes.tk.TkWrap;

public final class TkSmartRedirect
extends TkWrap {
    public TkSmartRedirect() {
        this("/");
    }

    public TkSmartRedirect(String location) {
        this(location, 303);
    }

    public TkSmartRedirect(final String location, final int code) {
        super(new Take(){

            @Override
            public Response act(Request req) throws IOException {
                return new RsRedirect(new RedirectParams(req, location).location(), code);
            }
        });
    }

    @Override
    public String toString() {
        return "TkSmartRedirect(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkSmartRedirect)) {
            return false;
        }
        TkSmartRedirect other = (TkSmartRedirect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TkSmartRedirect;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    private static final class RedirectParams {
        private final Request req;
        private final String origin;

        RedirectParams(Request req, String origin) {
            this.req = req;
            this.origin = origin;
        }

        public String location() throws IOException {
            StringBuilder loc = new StringBuilder(this.origin);
            URI target = URI.create(this.origin);
            URI uri = URI.create(new RqRequestLine.Base(this.req).uri());
            if (uri.getQuery() != null) {
                if (target.getQuery() == null) {
                    loc.append('?');
                } else {
                    loc.append('&');
                }
                loc.append(uri.getQuery());
            }
            if (uri.getFragment() != null) {
                loc.append('#');
                loc.append(uri.getFragment());
            }
            return loc.toString();
        }
    }
}

