/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import com.jcabi.http.request.JdkRequest;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.misc.EnglishLowerCase;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqLengthAware;
import org.takes.rq.RqMethod;
import org.takes.rq.RqPrint;
import org.takes.rq.RqRequestLine;
import org.takes.rs.RsWithBody;
import org.takes.rs.RsWithHeaders;
import org.takes.rs.RsWithStatus;

public final class TkProxy
implements Take {
    private final URI target;
    private final String label;

    public TkProxy(URI tgt) {
        this(tgt, TkProxy.class.getName());
    }

    public TkProxy(String tgt) {
        this(URI.create(tgt), TkProxy.class.getName());
    }

    public TkProxy(String tgt, String mark) {
        this(URI.create(tgt), mark);
    }

    public TkProxy(URI tgt, String mark) {
        this.target = tgt;
        this.label = mark;
    }

    @Override
    public Response act(Request req) throws Exception {
        String input = new RqRequestLine.Base(req).uri();
        URI output = this.target.resolve(URI.create(input));
        return this.response(input, output, this.request(req, output).fetch());
    }

    private com.jcabi.http.Request request(Request req, URI dest) throws Exception {
        String method = new RqMethod.Base(req).method();
        com.jcabi.http.Request proxied = new JdkRequest(dest).method(method);
        RqHeaders.Base headers = new RqHeaders.Base(req);
        for (String name : headers.names()) {
            if ("content-length".equals(new EnglishLowerCase(name).string())) continue;
            if (TkProxy.isHost(name)) {
                proxied = proxied.header(name, (Object)this.target);
                continue;
            }
            for (String value : headers.header(name)) {
                proxied = proxied.header(name, (Object)value);
            }
        }
        if (headers.header("Content-Length").iterator().hasNext() || headers.header("Transfer-Encoding").iterator().hasNext()) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            new RqPrint(new RqLengthAware(req)).printBody(output);
            proxied = proxied.body().set(output.toByteArray()).back();
        }
        return proxied;
    }

    private Response response(String home, URI dest, com.jcabi.http.Response rsp) {
        LinkedList<String> hdrs = new LinkedList<String>();
        hdrs.add(String.format("X-Takes-TkProxy: from %s to %s by %s", home, dest, this.label));
        for (Map.Entry entry : rsp.headers().entrySet()) {
            for (String value : (List)entry.getValue()) {
                String val = TkProxy.isHost((String)entry.getKey()) ? this.target.toString() : value;
                hdrs.add(String.format("%s: %s", entry.getKey(), val));
            }
        }
        return new RsWithStatus(new RsWithBody((Response)new RsWithHeaders(hdrs), rsp.binary()), rsp.status(), rsp.reason());
    }

    private static boolean isHost(String header) {
        return "host".equals(new EnglishLowerCase(header).string());
    }
}

