/*
 * Decompiled with CFR 0.152.
 */
package org.takes.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.takes.Response;

final class ResponseOf {
    private static final int BUFSIZE = 8192;
    private static final Pattern HTTP_MATCHER = Pattern.compile("^HTTP/(?:1\\.1|2) (?<code>\\d+).*$", 162);
    private final Response rsp;

    ResponseOf(Response response) {
        this.rsp = response;
    }

    public void applyTo(HttpServletResponse sresp) throws IOException {
        block27: {
            Iterator<String> head = this.rsp.head().iterator();
            Matcher matcher = HTTP_MATCHER.matcher(head.next());
            if (matcher.matches()) {
                sresp.setStatus(Integer.parseInt(matcher.group(1)));
                while (head.hasNext()) {
                    ResponseOf.applyHeader(sresp, head.next());
                }
                try (InputStream body = this.rsp.body();
                     ServletOutputStream out = sresp.getOutputStream();){
                    byte[] buff = new byte[8192];
                    int read = body.read(buff);
                    while (read >= 0) {
                        out.write(buff);
                        read = body.read(buff);
                    }
                    break block27;
                }
            }
            throw new IOException("Invalid response: response code not found");
        }
    }

    private static void applyHeader(HttpServletResponse sresp, String header) {
        String[] parts = header.split(":");
        String name = parts[0].trim();
        String val = parts[1].trim();
        if ("set-cookie".equals(name.toLowerCase(Locale.getDefault()))) {
            for (HttpCookie cck : HttpCookie.parse(header)) {
                sresp.addCookie(new Cookie(cck.getName(), cck.getValue()));
            }
        } else {
            sresp.setHeader(name, val);
        }
    }
}

