/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs.xe;

import java.io.IOException;
import java.util.Iterator;
import org.takes.rs.xe.XeSource;

public final class XeTransform<T>
implements Iterable<XeSource> {
    private final Iterable<T> objects;
    private final Func<T> func;

    public XeTransform(Iterable<T> list, Func<T> fnc) {
        this.objects = list;
        this.func = fnc;
    }

    @Override
    public Iterator<XeSource> iterator() {
        final Iterator<T> origin = this.objects.iterator();
        return new Iterator<XeSource>(){

            @Override
            public boolean hasNext() {
                return origin.hasNext();
            }

            @Override
            public XeSource next() {
                try {
                    return XeTransform.this.func.transform(origin.next());
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }

            @Override
            public void remove() {
                origin.remove();
            }
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XeTransform)) {
            return false;
        }
        XeTransform other = (XeTransform)o;
        Iterable<T> this$objects = this.objects;
        Iterable<T> other$objects = other.objects;
        if (this$objects == null ? other$objects != null : !this$objects.equals(other$objects)) {
            return false;
        }
        Func<T> this$func = this.func;
        Func<T> other$func = other.func;
        return !(this$func == null ? other$func != null : !this$func.equals(other$func));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Iterable<T> $objects = this.objects;
        result = result * 59 + ($objects == null ? 43 : $objects.hashCode());
        Func<T> $func = this.func;
        result = result * 59 + ($func == null ? 43 : $func.hashCode());
        return result;
    }

    public static interface Func<T> {
        public XeSource transform(T var1) throws IOException;
    }
}

