/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.takes.Response;
import org.takes.misc.Utf8String;
import org.takes.rs.Body;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWithStatus;
import org.takes.rs.RsWithoutHeader;
import org.takes.rs.RsWrap;

public final class RsWithBody
extends RsWrap {
    public RsWithBody(CharSequence body) {
        this((Response)new RsWithStatus(200), body);
    }

    public RsWithBody(byte[] body) {
        this((Response)new RsWithStatus(200), body);
    }

    public RsWithBody(InputStream body) {
        this((Response)new RsWithStatus(200), body);
    }

    public RsWithBody(URL url) {
        this((Response)new RsWithStatus(200), url);
    }

    public RsWithBody(Response res, CharSequence body) {
        this(res, new Utf8String(body.toString()).asBytes());
    }

    public RsWithBody(Response res, CharSequence body, Charset charset) {
        this(res, body.toString().getBytes(charset));
    }

    public RsWithBody(Response res, URL url) {
        this(res, new Body.Url(url));
    }

    public RsWithBody(Response res, byte[] body) {
        this(res, new Body.ByteArray(body));
    }

    public RsWithBody(Response res, InputStream body) {
        this(res, new Body.Stream(body));
    }

    RsWithBody(final Response res, final Body body) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return RsWithBody.append(res, body.length());
            }

            @Override
            public InputStream body() throws IOException {
                return body.stream();
            }
        });
    }

    private static Iterable<String> append(Response res, int length) throws IOException {
        String header = "Content-Length";
        return new RsWithHeader(new RsWithoutHeader(res, "Content-Length"), "Content-Length", Integer.toString(length)).head();
    }

    @Override
    public String toString() {
        return "RsWithBody(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsWithBody)) {
            return false;
        }
        RsWithBody other = (RsWithBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsWithBody;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

