/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.regex.Pattern;
import org.cactoos.Text;
import org.takes.Response;
import org.takes.misc.Utf8OutputStreamContent;
import org.takes.misc.Utf8String;
import org.takes.rs.RsWrap;

public final class RsPrint
extends RsWrap
implements Text {
    private static final Pattern FIRST = Pattern.compile("HTTP/1\\.1 \\d{3} [a-zA-Z ]+");
    private static final Pattern OTHERS = Pattern.compile("[a-zA-Z0-9\\-]+:\\p{Print}+");

    public RsPrint(Response res) {
        super(res);
    }

    public String print() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.print(baos);
        return new Utf8String(baos.toByteArray()).asString();
    }

    @Override
    public String asString() throws IOException {
        return this.print();
    }

    public String printBody() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printBody(baos);
        return new Utf8String(baos.toByteArray()).asString();
    }

    public String printHead() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printHead(baos);
        return new Utf8String(baos.toByteArray()).asString();
    }

    public void print(OutputStream output) throws IOException {
        this.printHead(output);
        this.printBody(output);
    }

    public void printHead(OutputStream output) throws IOException {
        this.printHead(new Utf8OutputStreamContent(output));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printHead(Writer writer) throws IOException {
        String eol = "\r\n";
        int pos = 0;
        try {
            for (String line : this.head()) {
                if (pos == 0 && !FIRST.matcher(line).matches()) {
                    throw new IllegalArgumentException(String.format("first line of HTTP response \"%s\" doesn't match \"%s\" regular expression, but it should, according to RFC 7230", line, FIRST));
                }
                if (pos > 0 && !OTHERS.matcher(line).matches()) {
                    throw new IllegalArgumentException(String.format("header line #%d of HTTP response \"%s\" doesn't match \"%s\" regular expression, but it should, according to RFC 7230", pos + 1, line, OTHERS));
                }
                writer.append(line);
                writer.append("\r\n");
                ++pos;
            }
            writer.append("\r\n");
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBody(OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        try (InputStream body = this.body();){
            int bytes;
            while ((bytes = body.read(buf)) >= 0) {
                output.write(buf, 0, bytes);
            }
        }
        finally {
            output.flush();
        }
    }

    @Override
    public String toString() {
        return "RsPrint(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsPrint)) {
            return false;
        }
        RsPrint other = (RsPrint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsPrint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

