/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import org.takes.Response;
import org.takes.rs.RsWithBody;

public final class RsPrettyJson
implements Response {
    private final Response origin;
    private final List<Response> transformed = new CopyOnWriteArrayList<Response>();

    public RsPrettyJson(Response res) {
        this.origin = res;
    }

    @Override
    public Iterable<String> head() throws IOException {
        return this.make().head();
    }

    @Override
    public InputStream body() throws IOException {
        return this.make().body();
    }

    private Response make() throws IOException {
        if (this.transformed.isEmpty()) {
            this.transformed.add(new RsWithBody(this.origin, RsPrettyJson.transform(this.origin.body())));
        }
        return this.transformed.get(0);
    }

    private static byte[] transform(InputStream body) throws IOException {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        try (JsonReader rdr = Json.createReader((InputStream)body);){
            JsonObject obj = rdr.readObject();
            try (JsonWriter wrt = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true)).createWriter((OutputStream)res);){
                wrt.writeObject(obj);
            }
        }
        catch (JsonException ex) {
            throw new IOException(ex);
        }
        return res.toByteArray();
    }

    public String toString() {
        return "RsPrettyJson(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsPrettyJson)) {
            return false;
        }
        RsPrettyJson other = (RsPrettyJson)o;
        Response this$origin = this.origin;
        Response other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        List<Response> this$transformed = this.transformed;
        List<Response> other$transformed = other.transformed;
        return !(this$transformed == null ? other$transformed != null : !((Object)this$transformed).equals(other$transformed));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        List<Response> $transformed = this.transformed;
        result = result * 59 + ($transformed == null ? 43 : ((Object)$transformed).hashCode());
        return result;
    }
}

