/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import org.takes.Response;
import org.takes.rs.RsWithBody;
import org.takes.rs.RsWithStatus;
import org.takes.rs.RsWithType;
import org.takes.rs.RsWrap;

public final class RsJson
extends RsWrap {
    public RsJson(final JsonStructure json) throws IOException {
        this(new Source(){

            @Override
            public JsonStructure toJson() {
                return json;
            }
        });
    }

    public RsJson(Source src) throws IOException {
        this(new RsWithBody(RsJson.print(src)));
    }

    public RsJson(Response res) {
        super(new RsWithType(new RsWithStatus(res, 200), "application/json"));
    }

    private static byte[] print(Source src) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonWriter writer = Json.createWriter((OutputStream)baos);){
            writer.write(src.toJson());
        }
        return baos.toByteArray();
    }

    @Override
    public String toString() {
        return "RsJson(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsJson)) {
            return false;
        }
        RsJson other = (RsJson)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsJson;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public static interface Source {
        public JsonStructure toJson() throws IOException;
    }
}

