/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.cactoos.Input;

interface Body
extends Input {
    @Override
    public InputStream stream() throws IOException;

    public int length() throws IOException;

    public static final class TempFile
    implements Body {
        private final File file;
        private final Body body;

        TempFile(Body body) {
            this.body = body;
            this.file = new File(System.getProperty("java.io.tmpdir"), String.format("%s-%s.tmp", TempFile.class.getName(), UUID.randomUUID().toString()));
        }

        @Override
        public InputStream stream() throws IOException {
            return Files.newInputStream(this.file().toPath(), new OpenOption[0]);
        }

        @Override
        public int length() throws IOException {
            return (int)this.file().length();
        }

        protected void finalize() throws Throwable {
            try {
                Files.delete(Paths.get(this.file.getAbsolutePath(), new String[0]));
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File file() throws IOException {
            File file = this.file;
            synchronized (file) {
                if (!this.file.exists()) {
                    this.file.deleteOnExit();
                    try (InputStream content = this.body.stream();){
                        Files.copy(content, Paths.get(this.file.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                return this.file;
            }
        }
    }

    public static final class Stream
    implements Body {
        private final InputStream stream;
        private final AtomicInteger length;

        Stream(InputStream input) {
            this.stream = input;
            this.length = new AtomicInteger(-1);
        }

        @Override
        public InputStream stream() throws IOException {
            this.estimate();
            return this.stream;
        }

        @Override
        public int length() throws IOException {
            this.estimate();
            return this.length.get();
        }

        private void estimate() throws IOException {
            if (this.length.get() == -1) {
                this.length.compareAndSet(-1, this.stream.available());
            }
        }
    }

    public static final class ByteArray
    implements Body {
        private final byte[] bytes;

        ByteArray(byte[] content) {
            this.bytes = (byte[])content.clone();
        }

        @Override
        public InputStream stream() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public int length() {
            return this.bytes.length;
        }
    }

    public static final class Url
    implements Body {
        private final URL url;

        Url(URL content) {
            this.url = content;
        }

        @Override
        public InputStream stream() throws IOException {
            return this.url.openStream();
        }

        @Override
        public int length() throws IOException {
            try (InputStream input = this.url.openStream();){
                int n = input.available();
                return n;
            }
        }
    }
}

