/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq.multipart;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.misc.EnglishLowerCase;
import org.takes.misc.Sprintf;
import org.takes.misc.VerboseIterable;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqLengthAware;
import org.takes.rq.RqMultipart;
import org.takes.rq.multipart.RqTemp;

public final class RqMtBase
implements RqMultipart {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private static final Pattern BOUNDARY = Pattern.compile(".*[^a-z]boundary=([^;]+).*");
    private static final Pattern NAME = Pattern.compile(".*[^a-z]name=\"([^\"]+)\".*");
    private static final String CRLF = "\r\n";
    private final Map<String, List<Request>> map;
    private final ByteBuffer buffer;
    private final InputStream stream;
    private final Request origin;

    public RqMtBase(Request req) throws IOException {
        this.origin = req;
        this.stream = new RqLengthAware(req).body();
        this.buffer = ByteBuffer.allocate(Math.min(8192, this.stream.available()));
        this.map = this.requests(req);
    }

    @Override
    public Iterable<Request> part(CharSequence name) {
        List values = this.map.getOrDefault(new EnglishLowerCase(name.toString()).string(), Collections.emptyList());
        VerboseIterable<Request> iter = values.isEmpty() ? new VerboseIterable(Collections.emptyList(), new Sprintf("there are no parts by name \"%s\" among %d others: %s", name, this.map.size(), this.map.keySet())) : new VerboseIterable<Request>(values, new Sprintf("there are just %d parts by name \"%s\"", values.size(), name));
        return iter;
    }

    @Override
    public Iterable<String> names() {
        return this.map.keySet();
    }

    @Override
    public Iterable<String> head() throws IOException {
        return this.origin.head();
    }

    @Override
    public InputStream body() throws IOException {
        return new CloseMultipart(this.origin.body());
    }

    private Map<String, List<Request>> requests(Request req) throws IOException {
        byte data;
        String header = new RqHeaders.Smart(req).single("Content-Type");
        if (!new EnglishLowerCase(header).string().startsWith("multipart/form-data")) {
            throw new HttpException(400, String.format("RqMtBase can only parse multipart/form-data, while Content-Type specifies a different type: \"%s\"", header));
        }
        Matcher matcher = BOUNDARY.matcher(header);
        if (!matcher.matches()) {
            throw new HttpException(400, String.format("boundary is not specified in Content-Type header: \"%s\"", header));
        }
        ReadableByteChannel body = Channels.newChannel(this.stream);
        if (body.read(this.buffer) < 0) {
            throw new HttpException(400, "failed to read the request body");
        }
        byte[] boundary = String.format("%s--%s", CRLF, matcher.group(1)).getBytes(ENCODING);
        this.buffer.flip();
        this.buffer.position(boundary.length - 2);
        LinkedList<Request> requests = new LinkedList<Request>();
        while (this.buffer.hasRemaining() && (data = this.buffer.get()) != 45) {
            this.buffer.position(this.buffer.position() + 1);
            requests.add(this.make(boundary, body));
        }
        return RqMtBase.asMap(requests);
    }

    private Request make(byte[] boundary, ReadableByteChannel body) throws IOException {
        File file = File.createTempFile(RqMultipart.class.getName(), ".tmp");
        try (SeekableByteChannel channel = Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            channel.write(ByteBuffer.wrap(this.head().iterator().next().getBytes(ENCODING)));
            channel.write(ByteBuffer.wrap(CRLF.getBytes(ENCODING)));
            this.copy(channel, boundary, body);
        }
        return new RqTemp(file);
    }

    private void copy(WritableByteChannel target, byte[] boundary, ReadableByteChannel body) throws IOException {
        int match = 0;
        boolean cont = true;
        while (cont) {
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                for (int idx = 0; idx < match; ++idx) {
                    this.buffer.put(boundary[idx]);
                }
                match = 0;
                if (body.read(this.buffer) == -1) break;
                this.buffer.flip();
            }
            ByteBuffer btarget = this.buffer.slice();
            int offset = this.buffer.position();
            btarget.limit(0);
            while (this.buffer.hasRemaining()) {
                byte data = this.buffer.get();
                if (data == boundary[match]) {
                    ++match;
                } else if (data == boundary[0]) {
                    match = 1;
                } else {
                    match = 0;
                    btarget.limit(this.buffer.position() - offset);
                }
                if (match != boundary.length) continue;
                cont = false;
                break;
            }
            target.write(btarget);
        }
    }

    private static Map<String, List<Request>> asMap(Collection<Request> reqs) throws IOException {
        HashMap<String, List<Request>> map = new HashMap<String, List<Request>>(reqs.size());
        for (Request req : reqs) {
            String header = new RqHeaders.Smart(req).single("Content-Disposition");
            Matcher matcher = NAME.matcher(header);
            if (!matcher.matches()) {
                throw new HttpException(400, String.format("\"name\" not found in Content-Disposition header: %s", header));
            }
            String name = matcher.group(1);
            if (!map.containsKey(name)) {
                map.put(name, new LinkedList());
            }
            ((List)map.get(name)).add(req);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqMtBase)) {
            return false;
        }
        RqMtBase other = (RqMtBase)o;
        Request this$origin = this.origin;
        Request other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }

    private class CloseMultipart
    extends FilterInputStream {
        CloseMultipart(InputStream input) {
            super(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                for (List requests : RqMtBase.this.map.values()) {
                    for (Request request : requests) {
                        request.body().close();
                    }
                }
            }
        }
    }
}

